<?php
/*
    +----------------------------------------------------------------------+
    | Classe Swish                                                         |
    +----------------------------------------------------------------------+
    | Class for accessing a swish-e (www.swish-e.org) search index with PHP|
    | This class is based on code of Olivier Meunier (www.neokraft.net)    |
    | and enhanced                                                         |	     
    +----------------------------------------------------------------------+
    | Author:   Timo Haberkern (original: Olivier Meunier)                 |
    | Version:  1.0.0                                                      |
    | Last change: 22.05.2003                                              |
    +----------------------------------------------------------------------+
*/
class SwishSearch
{
    /**
    * Common parameters and properties
    */
    var $str_engine = "swish\\swish-e.exe"; //--- Commandline executeable of swish (standard: swish-e[.exe])
    
    //--- no need for changing anything below this line
    var $str_index_file;
    var $str_separator = '@@@@@';
    
    var $strSearchQuery;
    var $get_params;
    var $sort_params;
    var $first_result;
    var $last_result;
    
    var $err = FALSE;
    
    /**
    * Standard constructor
    *
    * @str_index_file    string        The name and path of the index file
    * @str_engine        string        The commandline executeable of swish
    *
    * return            void    
    */
    function SwishSearch($str_index_file, $str_engine="")
    {
        $this->str_index_file = $str_index_file;
        
        if ($str_engine != "")
            $this->str_engine = $str_engine;
    }
    
    
    /**
    * Method: set_params
    *
    * @SearchQuery     string        SearchQuery
    * @get_params      array         Include these document properties in the output "prop1 prop2 ..."
    * @sort_params     string        Sort these document properties in the output "prop1 prop2 ..."
    * @first_result    integer       Index of the first search result to show
    * @last_result     integer       The maximum number of results to return
    *
    * return            void
    */
    function set_params($SearchQuery, $get_params=array(), $sort_params="", $first_result="", $last_result="")
    {
        $this->SearchQuery = $SearchQuery;
        $this->get_params = $get_params;
        $this->sort_params = $sort_params;
        $this->first_result = $first_result;
        $this->last_result = $last_result;
    }
    
    
    /**
    * Mthode: exec_swish
    *
    * return            void
    */
    function exec_swish()
    {
        //--- prepare the command line execution of the swish-e search client
		$this->SearchQuery = '"'.chop(str_replace('\(','(',str_replace('\)',')',str_replace('\*','*',escapeshellcmd($this->SearchQuery).' ')))).'"';
		
        $cmd =    $this->str_engine." ".
                ' -f '.$this->str_index_file.
                ' -w "'.$this->SearchQuery.'"'.
                ' -d '.$this->str_separator;
        
        //---  Include these document properties in the output "prop1 prop2 ..."
        if(count($this->get_params) > 0)
        {
            $ligne_params = implode(" ",$this->get_params);
            $cmd .= " -p ".$ligne_params;
        }
        
        //---  Sort these document properties in the output "prop1 prop2 ..."
        if($this->sort_params != "") {
            $cmd .= " -s ".$this->sort_params;
        }
        
        //--- begin results at this number
        if($this->first_result != "") {
            $cmd .= " -b ".$this->first_result;
        }
        
        //--- The maximum number of results to return
        if($this->last_result != "") {
            $cmd .= " -m ".$this->last_result;
        }
        
        $cmd .= " -H 2 -x \"%r#@%p#@%t#@%l#@%d#@<swishlastmodified fmt='%Y-%m-%d'>\\n\"";
        
        //--- execute complete commandline
        $this->cmd = $cmd;
	
	exec($cmd, $this->arry_swish, $result);

        //--- The result is stored in the arry_swish array
    }
    
    
    /**
    * parses the search result
    * return            void
    */    
    function parse_result()
    {
    	$objResultSet = new SearchResultSet();
    	
        $i=0;
        
        //On passe en revue chaque ligne du tableau
        foreach($this->arry_swish as $value)
        {
            //Si on trouve une ligne qui commence par "err", on arrte tout et
            //on initialise la proprit $err
            if(ereg("^err",$value))
            {
                $this->err = TRUE;
                break 1;
            }
            
            //--- The number of hits
            if(ereg("^# Number of hits: ([0-9]*)", $value, $Tnb)) 
            {
            	$objResultSet->nHitCount = $Tnb[1];
            }
            
            //--- The index maintainer
            if(ereg("^# Maintained by: (.*)",$value,$Tnb)) 
            {
                $objResultSet->strIndexMaintainer = $Tnb[1];
            }
            
            //--- The index timestamp
            if(ereg("^# Indexed on: (.*)",$value,$Tnb)) 
            {
                $objResultSet->strIndexTimeStamp = $Tnb[1];
            }
            
            //--- The index name
            if(ereg("^# Name: (.*)",$value,$Tnb)) 
            {
                $objResultSet->strIndexName = $Tnb[1];
            }
            
            //--- The search time
            if(ereg("^# Search time: (.*)",$value,$Tnb)) 
            {
                $objResultSet->strSearchTime = $Tnb[1];
            }
            
            //--- The run time
            if(ereg("^# Run time: (.*)",$value,$Tnb)) 
            {
                $objResultSet->strRunTime = $Tnb[1];
            }
            
            //--- Search result
            if(!ereg("^[.#]", $value))
            {
            	$objSearchResult = new SearchResult();
				                
                $arry_tmp = explode("#@",$value);
                
/*               foreach ($arry_tmp as $Line)
                {
                	echo $Line."<br>";	
                }
                echo "<br>";*/
                
                
                $strFilePath = str_replace("/", "\\", $arry_tmp[1]);
                $arry_path = explode("\\", $strFilePath);
                                
                $objSearchResult->m_strFileTitle = $arry_path[sizeof($arry_path)-1];
                $objSearchResult->m_nRanking 	 = $arry_tmp[0];
                $objSearchResult->m_strFileUrl   = $arry_tmp[1];
                $objSearchResult->m_nDocumentSize = $arry_tmp[3];
                $objSearchResult->m_strDescription = $arry_tmp[4];
                $objSearchResult->m_strDocumentLastModified = strtotime($arry_tmp[5]);
                
                $objResultSet->arr_Results[] = $objSearchResult;
                                
                $i++;                                
            }
        }
        
        return $objResultSet;
    }
    
    
    /**
    * 
    *
    * return            array        Tableau associatif de rsultats
    */
    function startSearch()
    {
        $this->exec_swish();
        return $this->parse_result();
    }

}//--- End of class SwishSearch
?> 
