// Copyright (c) 2008 Oliver Lau <ola@ctmagazin.de>
// Heise Zeitschriften Verlag, Hannover, Germany

#ifndef __IMAGESCALER_H_
#define __IMAGESCALER_H_

// #define USE_THREADPOOL
#undef USE_THREADPOOL

#ifdef USE_THREADPOOL
#include <ThreadPool.h>
#else
#include <QFutureWatcher>
#endif

#include <QObject>
#include <QString>
#include <QStringList>
#include <QTime>

#include <QFileInfo>
#include <QImageReader>
#include <QImageWriter>

#include <QtGui/QWidget>
#include <QtGui/QSpinBox>
#include <QtGui/QLabel>
#include <QtGui/QProgressBar>
#include <QtGui/QPushButton>
#include <QtGui/QTextEdit>

#include "imagescaler_p.h"

class ImageScaler : public QWidget
{
    Q_OBJECT

public:
    ImageScaler(int numThreads, QWidget* parent = 0);
    ~ImageScaler();

public slots:
    void open(void);
    void on_scalingFinished(void);
    void on_numThreadsChanged(int);
    void startStop(void);

private: // methods
    void start(void);
    void stop(void);
    void decorateButtons(void);

signals:
    void showMessage(const QString& msg);

private: // variables
    QPushButton* selectButton;
    QPushButton* startStopButton;
    QSpinBox* spinBoxNumThreads;
    QSpinBox* spinBoxWidth;
    QSpinBox* spinBoxHeight;
    QProgressBar* progressBar;
    QStringList files;
    QTime timer;
    bool running;
#ifdef USE_THREADPOOL
	ThreadPool* pool;
#else
    QFutureWatcher<void> futureWatcher;
    ImageScalerPrivate scaler;
#endif // USE_THREADPOOL
};

#endif // __IMAGESCALER_H_
