// Copyright (c) 2008 Oliver Lau <ola@ctmagazin.de>
// Heise Zeitschriften Verlag, Hannover, Germany

#ifndef __WORKERTHREAD_H_
#define __WORKERTHREAD_H_

#include <QThread>
#include <QWaitCondition>
#include <QSemaphore>

#include "ThreadPool.h"

class WorkerThread : public QThread
{
	Q_OBJECT

public:
	WorkerThread(ThreadPool* pool, QObject* parent = 0);
	~WorkerThread();

	/// The worker thread's main loop processes the thread pool's job queue
	/// and calls signalReady() when there are no more jobs left.
	virtual void run(void);
	void trigger(void);
	void terminate(void);
	bool isQuitting(void) { return doQuit; }
	bool isWaiting(void) { return idling; }

private:
	bool doQuit;
	bool idling;

	ThreadPool* pool;
	QSemaphore* ready;

	QMutex triggerMutex;
	QWaitCondition triggerCond;

	unsigned int id;
};

#endif // __WORKERTHREAD_H_
