#!/bin/sh
#
# Ueberprueft, ob eine x11vnc installiert ist und startet ihn.
# Falls nicht, dann laedt das Skript ein x11vnc aus dem Netz,
# legt ihn ins Benutzerverzeichnis ab und startet ihn
#
# Reiko Kaps <rek@ctmagazin.de> 2008
# Version 0.1 

#############################
# was tun, wenn Benutzer 
# abbricht ... cleaning aufrufen!
trap "cleaning" SIGINT SIGTERM EXIT 


##################################################
# WICHTIGE Parameter, die der Helfer anpassen muss
LISTENERURL="meinhelfer.example.net:55000"
# überschreibt Vorgabe mit Kommandozeilen-Parameter 
# LISTENERURL=${1-"meinhelfer.example.net:55000"}
X11VNC_URL="http://www.karlrunge.com/x11vnc/bins/x11vnc-0.9.4_TEST_i386-none-linux"
#X11VNC_URL="http://www.heise.de/cthelper/x11vnc"
X11VNC_MD5=a234dc2ec7ff6cf8cf146dd00f8579b9
ACCEPT="popup" 


##################################################
# Sonstige Einstellungen, benötigen keine Änderung
X11VNC_DIR=/tmp/ct-helfer
X11VNC_BIN=x11vnc
LOGFILE="log-"`date +%s`
VNCPAR=" -noxdamage -once -timeout 30 -connect "${LISTENERURL}" -o "${X11VNC_DIR}/${LOGFILE}
if [ "$ACCEPT" == "popup" ]; then
    VNCPAR=${VNCPAR}" -accept "${ACCEPT}
fi


#############################
# installierten x11vnc finden
function search_vnc()
{
    X11VNC_PATH=`which ${X11VNC_BIN}`
    if [ "$?" -gt 0 ]; then
	echo "Konnte x11vnc nicht auf dem System finden, starte Download ..."
	load_vnc
	return 
    else
	if [ -x ${X11VNC_PATH} ]; then
	    echo "x11vnc ist bereits vorhanden und ausfuehrbar ... [${X11VNC_PATH}]"
	fi	
    fi
}

#############################
# x11vnc aus dem Netz laden
function load_vnc()
{
        
    # X11VNC_PATH setzen
    X11VNC_PATH=${X11VNC_DIR}/${X11VNC_BIN}

    # Download starten
    get_url ${X11VNC_URL} ${X11VNC_PATH}

    # ausführbar machen
    chmod +x ${X11VNC_PATH}

    # überprüfen 
    # MD5SUM=`md5sum ${X11VNC_PATH} | awk '{ print $1; }'`
    MD5SUM=`md5sum < ${X11VNC_PATH}`
    MD5SUM=${MD5SUM%%"-"}
    MD5SUM=${MD5SUM// /}

    if [ "${X11VNC_MD5}" != "${MD5SUM}" ]; then
	echo ">${X11VNC_MD5:-2:$LEN}<>${MD5SUM}<"
	echo "Fehler: Die empfangende Version von x11vnc unterscheidet sich vom Orginal!"
	echo "Breche sicherheitshalber das Skript ab!"
	exit -1
    else
	echo -ne "MD5 stimmt [${MD5SUM}].\n" 
    fi
}


#############################
# Verbindung aufbauen
function vnc_connect()
{

    echo "Starte VNC-Server und verbinde zu ${LISTENERURL}"
    ${X11VNC_PATH} ${VNCPAR} & x11vncpid=$!

    # Strg-C im Terminalfenster  beendet den VNC-Server
    echo -ne "Suche X-Terminal "
    TERMINALS="xterm gnome-terminal konsole rxvt aterm"
    for BIN in `echo $TERMINALS`
    do
	XTERM=`which ${BIN}` 
	if [ "$?" -gt 0 ]; then
	    echo -ne "."
	else
	    echo -ne "ist [${XTERM}]\n"
	    break
	fi
    done
	
    $XTERM -title "ct-Helferlein: Mit Strg-C beenden" \
	-e tail -f ${X11VNC_DIR}/$LOGFILE & xdialogpid=$!   

    
    # solang wie beide Programm laufen ...
    # sonst den Rest beenden
    while ps $x11vncpid > /dev/null  && ps $xdialogpid > /dev/null
    do
	sleep 5
    done
    
    if ps $x11vncpid > /dev/null ; then	
	kill $x11vncpid 
    else
	kill $xdialogpid	
    fi
    
    echo "VNC-Server beendet!"
}

#############################
# alles aufraeumen
function cleaning()
{
    # 1. x11vnc aus ${X11VNC_DIR} loeschen
    if [ -x ${X11VNC_DIR}/${X11VNC_BIN} ]; then
	echo -n "Entferne ${X11VNC_DIR}/${X11VNC_BIN} ..."
	rm ${X11VNC_DIR}/${X11VNC_BIN} > /dev/null
	echo "[fertig]"
    fi
    
    # 2. versuche, alle laufenden Instanzen von x11vnc zu beenden
    echo -n "Beende alle laufenden Instanzen von ${X11VNC_BIN} ..."
    killall -KILL ${X11VNC_BIN} > /dev/null
    if [ "$?" -eq "0" ]; then
	echo "[Beendet]"
    else
	echo "[kein Prozess]"
    fi

    # Tastatur-Wiederholung an
    xset r on
}

#############################
# URL holen
# wget, curl oder per bash
function get_url()
{
    # Funktionsparameter 
    local QUELLE=$1
    local ZIEL=$2
    local prgs="wget curl lynx"
            
    
    for BIN in `echo $prgs`
    do
	echo -ne "Suche nach Download-Hilfe ... $BIN ... "
	PRG=`which $BIN`
	if [ "$?" -gt 0 ]; then
	    echo -ne "NICHT gefunden.\n"
	else
	    echo -ne "GEFUNDEN.\n"
	    break
	fi
    done

    case "$BIN" in
	wget)
	    PARAMETER=${QUELLE}" -O "${ZIEL}
	    ;;
	curl)
	    PARAMETER="-o "${ZIEL}" "${QUELLE}
	    ;;
	lynx)
	    PARAMETER="-source "${QUELLE}" > "${ZIEL}
	    ;;
	*)
    esac
    
    $PRG $PARAMETER
    error=$?
    if [ "$error" -gt 0 ]; then
	echo "Beim Download von $QUELLE ging etwas schief!"
	echo "Fehlercode von $PRG: $error"
	exit -1
    fi
    
}



#############################
# Main

if [ "$UID" -eq 0 ]; then
    echo "Fehler: Das ct-Helfer-Skript laeuft nicht als Root-Benutzer."
    exit -1
fi

if [ -z "$DISPLAY" ]; then
    echo "Fehler: Das ct-Helfer-Skript benötigt ein laufendes X Window."
    exit -1
fi

# lokales ct-helfer-Verzeichnis erzeugen
if [ -d ${X11VNC_DIR} ]; then
    echo "Lokales ct-helfer-Verzeichnis [${X11VNC_DIR}] schon vorhanden ..."
else
    echo "Erzeuge lokales ct-helfer-Verzeichnis [${X11VNC_DIR}] ..."
    mkdir -p ${X11VNC_DIR}
fi

# 1. Programme suchen
search_vnc

# 2. Ausführen
vnc_connect

# 3. und Ende
exit 0
