/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.lcdui.game.TiledLayer;

public class MobileFishCanvas
extends GameCanvas
implements Runnable {
    private Thread gameLoop;
    private MobileFish midlet;
    private static final int MILLIS_PER_TICK = 50;
    private Sprite freddy;
    private Sprite heart;
    private Sprite key;
    private Sprite star;
    private Sprite background;
    private TiledLayer stones;
    private int power = 100;
    LayerManager layerManager;
    Camera camera;

    public MobileFishCanvas(MobileFish aMIDlet) throws IOException {
        super(true);
        this.midlet = aMIDlet;
        this.init();
    }

    private void init() throws IOException {
        this.layerManager = new LayerManager();
        this.freddy = new Sprite(Image.createImage((String)"/Freddy.png"));
        this.freddy.setPosition(16, 184);
        this.layerManager.append((Layer)this.freddy);
        this.heart = new Sprite(Image.createImage((String)"/Heart.png"));
        this.heart.setPosition(100, 100);
        this.layerManager.append((Layer)this.heart);
        this.star = new Sprite(Image.createImage((String)"/Star.png"));
        this.star.setPosition(120, 120);
        this.layerManager.append((Layer)this.star);
        this.key = new Sprite(Image.createImage((String)"/Key.png"));
        this.key.setPosition(100, 10);
        this.layerManager.append((Layer)this.key);
        this.background = new Sprite(Image.createImage((String)"/Background.png"));
        this.stones = new TiledLayer(16, 16, Image.createImage((String)"/Stone_Tiles.png"), 16, 16);
        int[][] tiles = new int[][]{{7, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 8}, {5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4}, {5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4}, {5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4}, {5, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 6}, {5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4}, {5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4}, {5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4}, {9, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 4}, {5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4}, {5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4}, {5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4}, {5, 0, 0, 0, 0, 0, 0, 0, 0, 6, 7, 7, 7, 7, 7, 7}, {5, 0, 0, 0, 0, 0, 0, 6, 7, 7, 7, 7, 7, 7, 7, 7}, {5, 0, 0, 0, 0, 0, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7}, {0, 3, 3, 3, 3, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7}};
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                this.stones.setCell(j, i, tiles[i][j]);
            }
        }
        this.layerManager.append((Layer)this.stones);
        this.layerManager.append((Layer)this.background);
        this.camera = new Camera(this, this.background);
    }

    protected void showNotify() {
        this.gameLoop = new Thread(this);
        this.gameLoop.start();
    }

    protected void hideNotify() {
        this.gameLoop = null;
    }

    public void run() {
        Thread t = Thread.currentThread();
        while (t == this.gameLoop) {
            long startTime = System.currentTimeMillis();
            this.update();
            this.render();
            this.flushGraphics();
            long timeTaken = System.currentTimeMillis() - startTime;
            if (timeTaken >= 50L) continue;
            try {
                Thread.sleep(50L - timeTaken);
            }
            catch (InterruptedException ex) {}
        }
    }

    private int update() {
        int keyStates = this.getKeyStates();
        int freddyLastX = this.freddy.getX();
        int freddyLastY = this.freddy.getY();
        int speed = 2;
        if ((keyStates & 4) != 0) {
            this.freddy.move(-1 * speed, 0);
            this.freddy.setTransform(2);
        } else if ((keyStates & 0x20) != 0) {
            this.freddy.move(speed, 0);
            this.freddy.setTransform(0);
        } else if ((keyStates & 2) != 0) {
            this.freddy.move(0, -1 * speed);
        } else if ((keyStates & 0x40) != 0) {
            this.freddy.move(0, speed);
        }
        if (this.freddy.collidesWith(this.stones, true)) {
            this.freddy.setPosition(freddyLastX, freddyLastY);
            --this.power;
        }
        if (this.freddy.collidesWith(this.heart, true)) {
            this.heart.setVisible(false);
            this.power += 50;
        }
        if (this.freddy.collidesWith(this.star, true)) {
            this.power -= 40;
        }
        this.camera.move(this.freddy.getX(), this.freddy.getY());
        if (this.freddy.collidesWith(this.key, true)) {
            this.stopGame();
        }
        if (this.power < 1) {
            this.stopGame();
        }
        return 0;
    }

    private void stopGame() {
        this.midlet.quit();
    }

    private void render() {
        Graphics g = this.getGraphics();
        this.layerManager.setViewWindow(this.camera.x, this.camera.y, this.getWidth(), this.getHeight());
        this.layerManager.paint(g, 0, 0);
        g.setColor(255, 255, 255);
        g.drawString("Power: " + this.power, this.getWidth(), 0, 24);
    }
}

