(script-fu-register "script-fu-flower"
  _"_Flower Power"
  _"Rotates arbitrary shapes into flower-like pattern"
  "Susanne Schmidt <tryshee@gmail.com>"
  "Susanne Schmidt"
  "06. Oct. 2008"
  "RGB* GRAY*"
  SF-IMAGE      "Image"           0
  SF-DRAWABLE   "Drawable"        0
  SF-VALUE _"Set X as rotation center"  "200"
  SF-VALUE _"Set Y as rotation center"  "200" 
  SF-VALUE _"Rotation angle (degree)" "30"
  SF-VALUE _"Rotation steps (number of times)" "4"
  SF-TOGGLE _"Merge visible layers?" FALSE
 )

(script-fu-menu-register "script-fu-flower" "<Image>/Testing")

(define (script-fu-flower image drawable 
                          xcenter ycenter angle steps
                          merge-visible-layer)
    (let* (
          (layer 0)
          (floating-selection 0)
          )

    (while (> steps 0)
        (set! layer (car (gimp-image-get-active-layer image)))
    
        (gimp-edit-copy drawable)
        (gimp-edit-paste drawable FALSE)
    
        (gimp-drawable-transform-rotate drawable
                                        angle
                                        FALSE
                                        xcenter ycenter
                                        TRANSFORM-FORWARD 
                                        3
                                        FALSE
                                        3
                                        TRANSFORM-RESIZE-ADJUST)
    
        (set! floating-selection (car (gimp-image-get-floating-sel image)))

        (gimp-floating-sel-to-layer floating-selection)
        (gimp-image-set-active-layer image layer)
        (plug-in-autocrop-layer 1 image layer) 

        (set! steps (- steps 1))
    )
    )

    (if (= merge-visible-layer TRUE)
        (gimp-image-merge-visible-layers image EXPAND-AS-NECESSARY)
    )

    (gimp-displays-flush)
)

