﻿// PNRP Beacon - Ein PNRP Beispielprogramm
// benoetigt .NET Runtime 3.5 SP1 oder neuer
// Windows 2008 Server oder Vista mit PNRP 
// IPv6 Netzwerkanbindung
//
// 12/2008 Carsten Strotmann
// (c) 2008 c't Magazin, Heise Verlag
//

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Net;
using System.Collections;
using System.Collections.ObjectModel;

namespace PnrpBeacon
{
    /// <summary>
    /// Logik (Code-Behind) fuer das Anwendungsfenster
    /// </summary>
    public partial class Window1 : Window
    {
        PnrpSearch search = null;
        PnrpTopics topics = null;
        PnrpLog log = null;

        public Window1()
        {
            InitializeComponent();

            // die PNRP Suche in einem eigenen Thread starten
            search = new PnrpSearch();
            topics = search.getTopics();
            topic_list.DataContext = topics;
            log = search.getLog();
            log_list.DataContext = log;
            search.startSearch();
        }

        // Topic Hinzufuegen oder Entfernen
        // ist ein Topic schon in der Suchliste, wird dieser
        // entfernt, ansonsten wird ein neuer Topic in der
        // Suchliste erstellt
        private void add_topic_Click(object sender, RoutedEventArgs e)
        {
            if (topics.ContainsTopic(new_topic.Text))
            {
                // Topic hinzufuegen
                search.removeTopic(new_topic.Text);
                new_topic.Text = "";
                add_topic.IsEnabled = false;
            }
            else
            {
                // Topic entfernen
                search.addTopic(new_topic.Text);
                new_topic.Text = "";
                add_topic.IsEnabled = false;
            }
        }

        // Eingabe im Topic-Feld pruefen
        // Knopf zum hinzufuegen/entfernen wird erst bei
        // Eingaben ab 3 Zeichen freigeschaltet
        private void new_topic_KeyUp(object sender, KeyEventArgs e)
        {
            add_topic.IsEnabled = (new_topic.Text.Length > 2);
            if (topics.ContainsTopic(new_topic.Text)) 
            {
                add_topic.Content = "remove";
            }
            else 
            {
                add_topic.Content = "add";
            }
        }

        // Feenster wird geschlossen, der Such-Thread im Hintergrund
        // wird beendet und die Anwendung gestoppt
        private void Window_Closing(object sender, System.ComponentModel.CancelEventArgs e)
        {
            search.stopSearch();
        }

        // ein Topic in der Liste wurde angewaehlt
        private void topic_list_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            if (e.AddedItems.Count > 0)
            {
                // Topic laden
                PnrpTopic topic = (PnrpTopic)e.AddedItems[0];
                
                // Topic-Name in das Eingabefeld setzen,
                // Knopf zum Entfernen des Topic einschalten
                new_topic.Text = topic.Name;
                add_topic.Content = "remove";
                add_topic.IsEnabled = true;

                // Endpoints fuer den gewaehlten Topic laden
                ObservableCollection<string> endpoints = new ObservableCollection<string>();
                peer_list.DataContext = endpoints;
                Hashtable h = topic.Peers;
                
                // wenn Endpoints (PNRP Peers) gefunden wurden, 
                // diese in der Peers-Listbox anzeigen
                // endpoint.Value enhaelt den PNRP-Payload, hier
                // ein String mit dem entfernten Maschinenname,
                // Betriebssystem und CPU-Anzahl
                if (h.Count > 0)
                {
                    foreach (DictionaryEntry endpoint in h)
                    {
                        endpoints.Add(endpoint.Key + " (" + endpoint.Value + ")");
                    }
                }
                else
                {
                    // es wurden noch keine Endpoints gefunden
                    endpoints.Add("No Endpoints found for Topic '" + topic.Name + "'");
                }
            }
        }
    }
}
