@echo off %debug%
setlocal

rem sqlbackup.cmd
rem
rem (c) 2009 c't und Johannes Endres
rem
rem Skript zum Artikel "Aufbausatz", c't 15/09, Seite 136

rem In diese Zeile tragen Sie die SQL-Instanz ein.
rem Diesen Namen entnehmen Sie am besten dem Anmelde-
rem Dialog des SQL Management Studio. Die Instanz
rem SQLEXPRESS auf dem Server AUFGEBOHRT sollte hier
rem als set SQLInstanz=AUFGEBOHRT\SQLEXPRESS stehen.
set SQLInstanz=

rem In diese Zeile tragen Sie die Namen aller zu 
rem sichernden Datenbanken ein. Die Namen sollten
rem durch Kommata getrennt sein. Zur Sicherung der
rem Datenbanken A und B leutet die Zeile also
rem set Datenbanken=A,B
rem Die Namen bernehmen Sie am besten per Copy&Paste
rem aus dem SQL Management Studio.
set Datenbanken=

rem In diese Zeile tragen Sie den Laufwerksbuchstaben
rem des Backup-Laufwerks mit dem Doppelpunkt ein. Das
rem Skript nutzt dort das Verzeichnis
rem   \SQLBackup
rem Eventuell schon
rem vorhandene Backups werden ueberschrieben.
rem Beispiel: 
rem set Laufwerk=E:
set Laufwerk=

rem ---- Ende der Konfiguration ----

rem Konfiguration prfen
if ""=="%SQLInstanz%"  (
	echo Bitte tragen Sie im Skript die SQL-Instanz ein!
	pause
	exit /b 2
	)

if ""=="%Datenbanken%"  (
	echo Bitte tragen Sie im Skript die zu sichernden Datenbanken ein!
	pause
	exit /b 1
	)

if ""=="%Laufwerk%"  (
	echo Bitte tragen Sie im Skript das Backup-Laufwerk ein!
	pause
	exit /b 3
	)

rem Gibt es das Verzeichnis schon?
if not exist "%Laufwerk%\SQLBackup" (
	mkdir "%Laufwerk%\SQLBackup" > nul || (
		echo Konnte "%Laufwerk%\SQLBackup" nicht anlegen.
		pause
		exit /b 4
	)
)

echo SQL-Skript %SQLSkript% erzeugen
rem Kann ich das SQL-Skript schreiben?
set SQLSkript="%temp%\%random%.sql"
copy nul %SQLSkript% > nul || (
	echo Kann SQL-Skript %SQLSkript% nicht schreiben.
	pause
	exit /b 5
	)

rem Befehle fr alle Datenbanken ins Skript
for %%d in (%Datenbanken%) do (
	echo BACKUP DATABASE [%%d] TO DISK='%Laufwerk%\SQLBackup\%%d.bak' WITH  INIT, NAME = N'%%d_Sicherung' >> %SQLSkript%
	echo BACKUP LOG [%%d] TO DISK='%Laufwerk%\SQLBackup\%%d_Log.bak'WITH INIT, NAME = N'%%d_Log_Sicherung' >> %SQLSkript%
	)
	
echo Sicherung starten
"%programfiles%\Microsoft SQL Server\100\Tools\Binn\SQLCMD.EXE" -i %SQLSkript% -S %SQLInstanz% -E -o %Laufwerk%\SQLBackup\BackupLog.txt

echo Backup-Log umbenennen
rem Zeitstempel erzeugen
for /f "tokens=1-3 delims=. " %%i in ('date/t') do set logname=FullBackup-%%k-%%j-%%i
for /f "tokens=1-2 delims=: " %%i in ('time/t') do set logname=%logname%-%%i-%%j.txt
ren %Laufwerk%\SQLBackup\BackupLog.txt %logname%

if ""=="%debug%" (
	echo SQL-Skript entsorgen
	erase %SQLSkript%
	)

echo Fertig.
exit /b 0