Const hostName = "."

Set objWMIService = GetObject("winmgmts:\\" & hostName & "\root\CIMV2")
Set colAccounts = objWMIService.ExecQuery( _
  "SELECT * FROM Win32_UserAccount WHERE LocalAccount = True")

accountList = ""
acc = 1
For Each oAccount In colAccounts
  ' Vordefinierte Konten wie Administrator und Gast berspringen
  If CInt(Mid(oAccount.SID, InStrRev(oAccount.SID, "-") + 1)) >= 1000 Then
    accountList = accountList & Right("  " & acc, 2) & " - " _
                  & oAccount.Name & VbCrLf
    acc = acc + 1
  End If
Next

prompt = "Welches Konto wollen Sie umbenennen?" & vbCrLf & vbCrLf _
         & accountList & vbCrLf _
         & "Bitte geben Sie die entsprechende Nummer ein:"
sel = InputBox(prompt, WScript.ScriptName)
If sel = "" Then WScript.Quit
nSel = 0
On Error Resume Next
nSel = CInt(sel)
On Error GoTo 0
If nSel < 1 Or nSel > acc - 1 Then
  MsgBox "Ungltige Eingabe", vbCritical, WScript.ScriptName
  WScript.Quit
End If

acc = 1
For Each oAccount In colAccounts
  If CInt(Mid(oAccount.SID, InStrRev(oAccount.SID, "-") + 1)) >= 1000 Then
    If acc = nSel Then
      Set oSelected = oAccount
      Exit For
    End If
    acc = acc + 1
  End If
Next
oldName = oSelected.Name

prompt = "Bitte geben Sie den neuen Namen fr das Konto " _
         & oldName & " ein:"
newName = InputBox(prompt, WScript.ScriptName)
If newName = "" Then WScript.Quit

result = oSelected.Rename(newName)
If result = 0 Then
  MsgBox "Das Konto " & oldName & " wurde erfolgreich in " _
         & newName & " umbenannt.", _
         vbInformation, WScript.ScriptName
Else
  MsgBox "Fehler beim Umbenennen des Kontos " & oldName _
         & " in " & newName & " (Fehlercode " & result & ").", _
         vbCritical, WScript.ScriptName
End If          
