<?php
// Copyright (c) 2009 Oliver Lau <oliver@von-und-fuer-lau.de>
// All rights reserved.
// $Id: mapurl.php 01e62dbd8c5f 2009/10/02 12:42:45 Oliver Lau <oliver@von-und-fuer-lau.de> $
include('globals.inc.php');

header('Content-type: text/x-json');

$id = isset($_GET['id'])? $_GET['id'] : '';
if ($id === '') {
    echo json_encode(array(
          'status' => E_INVALID_REQUEST,
          'message' => 'Parameter "id" is missing.',
         ));
    exit;
}

$origin = isset($_GET['origin'])? $_GET['origin'] : ''; // check if $origin really is a URL to avoid SQL injection attacks
if ($origin === '') {
    echo json_encode(array(
          'status' => E_INVALID_REQUEST,
          'message' => 'Parameter "origin" is missing.',
         ));
    exit;
}

$dbh = dbpconnect('private');
if (!$dbh) {
    echo json_encode(array(
          'status' => E_UNAVAILABLE,
          'message' => 'Cannot connect to database.',
         ));
    exit;
}

$response = array();
$sql = "SELECT destination FROM urlmappings WHERE origin = '$origin'";
$res = $dbh->query($sql);
if ($res) {
   foreach($res as $row) {
      array_push($response, array(
        'id' => $id,
        'destination' => $row['destination']
      ));
   }
   echo 'mappingCallback(' . json_encode($response) . ')';
}

?>