<?php
// Copyright (c) 2009 Oliver Lau <oliver@von-und-fuer-lau.de>
// All rights reserved.
// $Id: addtweet.php 858c266f2532 2009/09/07 13:35:01 Oliver Lau <oliver@von-und-fuer-lau.de> $
header('Content-type: text/x-json');
include('../globals.inc.php');

$d = '';
$fp = fopen('php://input', 'rb+');
while (!feof($fp))
    $d .= fread($fp, 4096);
fclose($fp);
if (!get_magic_quotes_gpc())
    $d = stripslashes($d);
$jsonArray = json_decode($d);

if (!$jsonArray) {
    echo json_encode(array(
          'status' => E_INVALID_REQUEST,
          'message' => 'Invalid or missing data.',
          'data' => $d
         ));
    exit;
}

$dbh = dbpconnect('.');
if (!$dbh) {
    echo json_encode(array(
          'status' => E_UNAVAILABLE,
          'message' => 'Cannot connect to database.',
          'data' => $d
         ));
    exit;
}

$ids = array();
$sth = $dbh->prepare('INSERT OR REPLACE INTO tweets (id, user_id, user_screen_name, user_name, created_at, tweet, in_reply_to_screen_name, in_reply_to_status_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?)');
foreach ($jsonArray as $json) {
    $rs = $sth->execute(array(
        $json->{'id'},
        $json->{'user_id'},
        $json->{'user_screen_name'},
        $json->{'user_name'},
        $json->{'created_at'},
        urldecode($json->{'text'}),
        $json->{'in_reply_to_screen_name'},
        $json->{'in_reply_to_status_id'}
    ));
    if (!$rs) {
       echo json_encode(array(
             'status' => E_INVALID_REQUEST,
             'message' => 'sth->execute() failed.',
             'data' => $d
            ));
       exit;
    }
    array_push($ids, $json->{'id'});
}

echo json_encode(array(
    'status' => E_OK,
    'message' => count($jsonArray) . " Tweets hinzugefügt/ersetzt.",
    'ids' => $ids
   ));
?>