<?php
header('Content-type: text/x-json');
include('../globals.inc.php');

$dbh = dbpconnect('.');
if (!$dbh) {
    echo json_encode(array(
          'status' => E_UNAVAILABLE,
          'message' => 'Cannot connect to database.',
          'data' => ''
         ));
    exit;
}

$dbh->exec('DROP TABLE IF EXISTS tweets');

$dbh->exec('
CREATE TABLE tweets (
 id INTEGER PRIMARY KEY,
 user_id INTEGER NOT NULL,
 user_screen_name TEXT,
 user_name TEXT,
 created_at DATETIME NOT NULL,
 tweet TEXT,
 in_reply_to_screen_name TEXT,
 in_reply_to_status_id INTEGER
)');

$dbh->exec('DROP INDEX IF EXISTS tweetidx');

$dbh->exec('
CREATE INDEX tweetidx ON tweets (
 user_screen_name,
 user_name,
 user_id,
 tweet
)');

$dbh->exec('DROP TABLE IF EXISTS urlmappings');

$dbh->exec('
CREATE TABLE urlmappings
(
 origin TEXT PRIMARY KEY,
 destination TEXT
)');


$dbh->exec('DROP TABLE IF EXISTS posts');

$dbh->exec('
CREATE TABLE posts
(
 id INTEGER PRIMARY KEY,
 url TEXT NOT NULL,
 created_at DATETIME NOT NULL,
 author TEXT NOT NULL,
 title TEXT NOT NULL,
 body TEXT NOT NULL
)');


echo json_encode(array(
    'status' => E_OK,
    'message' => 'OK.'
   ));
?>