<?php
// Copyright (c) 2009 Oliver Lau <oliver@von-und-fuer-lau.de>
// All rights reserved.
// $Id: search.php 4e7e9dd6fe91 2009/10/07 15:28:29 Oliver Lau <oliver@von-und-fuer-lau.de> $
include('globals.inc.php');

header('Content-type: text/x-json');

$q = $_GET['q'];
$first = $_GET['first'];
$count = $_GET['count'];
$exactMatch = $_GET['exact'] === '1';

if (!isset($first))
    $first = 0;

if (!isset($count))
    $count = 20;

$dbh = dbpconnect('private');
if (!$dbh) {
    echo json_encode(array(
          'status' => E_UNAVAILABLE,
          'message' => 'Cannot connect to database.',
          'data' => $HTTP_RAW_POST_DATA
         ));
    exit;
}

if (isset($q)) {
    if ($exactMatch) {
        $where = "WHERE tweet LIKE '%" . addslashes($q) . "%'";
    }
    else {
        // XXX: ungeprüfter GET-Parameter ist anfällig für SQL injection.
        $tokens = explode(' ', $q);
        $N = count($tokens);
        if ($N > 0) {
           $where = 'WHERE';
           $c1 = $N - 1;
           for ($i = 0; $i < $N; ++$i) {
              $t = $tokens[$i];
              $where .= " tweet LIKE '%$t%'";
              if ($i < $c1)
                $where .= " AND";
           }
        }
    }
}

$response = array();
$sql = "SELECT id, user_id, user_screen_name, user_name, created_at, tweet, in_reply_to_status_id, in_reply_to_screen_name FROM tweets $where ORDER BY created_at DESC LIMIT $first,$count";
$res = $dbh->query($sql);
if ($res) {
   foreach($res as $row) {
      array_push($response, array(
         'id' => $row['id'],
         'user' => array(
                     'id' => $row['user_id'],
                     'screen_name' => $row['user_screen_name'],
                     'name' => $row['user_name']
                   ),
         'created_at' => $row['created_at'],
         'text' => $row['tweet'],
         'in_reply_to_status_id' => $row['in_reply_to_status_id'],
         'in_reply_to_screen_name' => $row['in_reply_to_screen_name']
      ));
   }
  
   echo 'twitterCallback(' . json_encode($response) . ')';
}
?>