// Loosely based on a work by Remy Sharp, see http://remysharp.com/2007/05/18/add-twitter-to-your-blog-step-by-step/
// Modified Aug/Sep/Oct 2009 by Oliver Lau <ola@heise.de>
// $Id: twitter.js 429b7fc28d80 2009/10/09 12:49:20 Oliver Lau <oliver@von-und-fuer-lau.de> $

var tweet = {
		target: 'tweet',
		tweetCallback: 'twitterCallback',
		mapCallback: 'mappingCallback',
		first: 0,
		count: 15,
		maxCount: 2000,
		query: '',
		loaderIcon: '<img src="loading2.gif" style="border:0" width="16" height="16" title="Bitte warten ...">',
		ul: null
};


tweet.addNode = function(o) {
	var li = document.createElement('li');
	var userSpan = document.createElement('span');
	userSpan.className = 'twitterUser';
	userSpan.innerHTML = '<a href="http://twitter.com/' + o.user.screen_name + '" target="_blank">' + o.user.name + '</a>: ';
	var statusSpan = document.createElement('span');
	statusSpan.className = 'twitterStatus';
	statusSpan.innerHTML = linkify(o.text);
	var timeSpan = document.createElement('span');
	timeSpan.className = 'twitterTime';
	timeSpan.innerHTML = '<a href="http://twitter.com/' + o.user.screen_name + '/statuses/' + o.id + '" target="_blank">' + o.created_at + '</a>';
	if (o.in_reply_to_status_id) 
		timeSpan.innerHTML += ' in Erwiderung auf <a href="http://twitter.com/' + o.in_reply_to_screen_name + '/statuses/' + o.in_reply_to_status_id + '</a>';
	li.appendChild(userSpan);
	li.appendChild(statusSpan);
	li.appendChild(document.createElement('br'));
	li.appendChild(timeSpan);
	li.appendChild(document.createElement('br'));
	this.ul.appendChild(li);
}


tweet.substituteURLs = function(obj) {
	if (obj == null)
		return;
	for (var i = 0; obj[i] && (i < obj.length); ++i) {
		var o = obj[i];
		var link = document.getElementById(o.id);
		if (link == null)
			return false;
		link.onmouseover = null;
		link.title = o.destination;
		link.href = o.destination;
		link.innerHTML = o.destination;
	}
	return false;
}


tweet.mapUrl = function(id) {
	var link = document.getElementById(id);
	if (link == null)
		return false;
	var url = 'mapurl.php?id=' + id + '&origin=' + encodeURI(link.href);
	var script = document.createElement('script');
	script.setAttribute('src', url);
	document.getElementsByTagName('head')[0].appendChild(script);
}


tweet.render = function(obj) {
	var target = document.getElementById(this.target);
	var pageSpan = document.createElement('p');
	pageSpan.className = 'twitterPage';
	pageSpan.style.height = '16px';
	pageSpan.id = 'pageSpan';
	pageSpan.innerHTML = (obj.length == 0)? 'Die Suche verlief ergebnislos.' : '';
	this.ul = document.createElement('ul');
	var max = (obj.length > this.maxCount)? this.maxCount : obj.length;
	for (var i = 0; obj[i] && (i < max); ++i)
		this.addNode(obj[i]);
	clearSubtree(target);
	target.appendChild(pageSpan);
	target.appendChild(this.ul);
	var loader = document.getElementById('loader');
	loader.innerHTML = '';
	if (this.first > 1) {
		var prevButton = document.createElement('input');
		prevButton.type = 'button';
		prevButton.id = 'prevButton';
		prevButton.value = '<- jüngere Tweets';
		prevButton.onclick = function() { tweet.prev(); };
		prevButton.className = 'more';
		target.appendChild(prevButton);
	}
	target.appendChild(document.createTextNode(' '));
	if ((obj.length >= this.count) && (this.count < this.maxCount)) {
		var nextButton = document.createElement('input');
		nextButton.type = 'button';
		nextButton.id = 'nextButton';
		nextButton.value = 'ältere Tweets ->';
		nextButton.onclick = function() { tweet.next(); };
		nextButton.className = 'more';
		target.appendChild(nextButton);
	}
};


tweet.search = function () {
	var query = document.getElementById('query');
	window[this.tweetCallback] = function(obj) { tweet.render(obj); };
	window[this.mapCallback] = function(obj) { tweet.substituteURLs(obj); };
	var loader = document.getElementById('loader');
	loader.innerHTML = this.loaderIcon;
	var exactElement = document.getElementById('exact');
	var exact = 'exact=';
	if (exactElement)
		exact += ((exactElement.checked)? '1' : '0');
	if (query.value != tweet.query)
		this.first = 0;
	this.query = query.value;
	var url = 'search.php?' + exact + '&q=' + encodeURI(this.query) +
	'&first=' + this.first + '&count=' + this.count;
	var script = document.createElement('script');
	script.setAttribute('src', url);
	document.getElementsByTagName('head')[0].appendChild(script);
}


tweet.disablePrevNextButtons = function() {
	var prevButton = document.getElementById('prevButton');
	if (prevButton)
		prevButton.disabled = true;
	var nextButton = document.getElementById('nextButton');
	if (nextButton)
		nextButton.disabled = true;
};


tweet.proceed = function() {
	this.disablePrevNextButtons();
	this.search();
	scrollToTop('maincontent');
	return false;
};


tweet.prev = function() {
	this.first -= this.count;
	return this.proceed();
};


tweet.next = function() {
	this.first += this.count;
	return this.proceed();
};
