# -*- coding: utf-8 -*-
# coding=utf8
# Copyright (c) 2009-2010 Oliver Lau <oliver@von-und-fuer-lau.de>
# $Id: TwitterOAuthClient.py f0c416d8f5e7 2010/03/11 16:29:11 Oliver Lau <oliver@von-und-fuer-lau.de> $

import logging
from google.appengine.api import memcache
from google.appengine.api import urlfetch
from google.appengine.ext import db
from cgi import parse_qs
from django.utils import simplejson as json
from hashlib import sha1
from hmac import new as hmac
from random import getrandbits
from time import time
from urllib import unquote as urlunquote

from urllib_utf8 import encode, urlencode
import Session


class TwitterOAuthClient:
    proto = 'https://'
    request_url   = proto + 'twitter.com/oauth/request_token'
    access_url    = proto + 'twitter.com/oauth/access_token'
    authorize_url = proto + 'twitter.com/oauth/authorize'
    consumer_key = 'kSGWS...2w'
    consumer_secret = 'JBSn...SmZw'

    def __init__(self, session, reqh):
        self.callback_url = '%s/twitter/callback' % (reqh.request.application_url)
        self.session = session

    def make_request(self, url, token='', secret='', additional_params={},
                       protected=False, method='GET', payload=''):
        method = method.upper()
        params = { 'oauth_consumer_key': self.consumer_key,
                   'oauth_signature_method': 'HMAC-SHA1',
                   'oauth_timestamp': str(int(time())),
                   'oauth_nonce': str(getrandbits(64)),
                   'oauth_version': '1.0' }
        params.update(additional_params)
        if token: params['oauth_token'] = token
        elif self.callback_url: params['oauth_callback'] = self.callback_url
        message = u'&'.join(map(encode, [method, url, u'&'.join('%s=%s' % (encode(k), encode(params[k])) for k in sorted(params))]))
        key = '%s&%s' % (self.consumer_secret, secret)
        logging.info('MESSAGE = %s' % message)
        params['oauth_signature'] = hmac(key, message, sha1).digest().encode('base64')[:-1]
        if method == 'GET':
            logging.info('GET: %s?%s' % (url, urlencode(params)))
            return urlfetch.fetch('%s?%s' % (url, urlencode(params)), method=method)
        elif method == 'POST':
            logging.info('POST: %s %s' % (url, payload))
            return urlfetch.fetch(url, payload=urlencode(params), method=method)
        else:
            raise UserWarning, 'Method %s not implemented. Please use GET or POST' % (method)

    def get_auth_token(self):
        response = self.make_request(self.request_url)
        result = self.extract_credentials(response)
        auth_token  = result['token']
        auth_secret = result['secret']
        self.update_auth(auth_token, auth_secret)
        return auth_token

    def get_authorization_url(self):
        return '%s?oauth_token=%s' % (self.authorize_url, self.get_auth_token())

    def make_memcache_authkey(self, auth_token):
        return 'oauth_twitter_%s' % (auth_token)

    def extract_credentials(self, response):
        token = None
        secret = None
        parsed_results = parse_qs(response.content)
        if 'oauth_token' in parsed_results:
            token = parsed_results['oauth_token'][0]
        if 'oauth_token_secret' in parsed_results:
            secret = parsed_results['oauth_token_secret'][0]
        if token is None or secret is None or response.status_code != 200:
            raise Exception, 'Could not extract token/secret: %s' % (response.content)
        return { 'token' :  token,
                 'secret':  secret }

    def update_auth(self, auth_token, auth_secret):
        self.session.data.twitter_oauth_token  = auth_token
        self.session.data.twitter_oauth_secret = auth_secret
        self.session.data.put()
        memcache_key = self.make_memcache_authkey(auth_token)
        memcache.set(memcache_key, auth_secret, time=20)
        logging.info('auth_token %s stored in Memcache (%s)' % (auth_token, memcache_key))

    def lookup_user_info(self, access_token, access_secret):
        response = self.make_request(
            'https://twitter.com/account/verify_credentials.json',
            token=access_token, secret=access_secret, protected=True)
        data = json.loads(response.content)
        return { 'id'         : data['id'],
                 'username'   : data['screen_name'],
                 'name'       : data['name'],
                 'picture'    : data['profile_image_url'],
                 'url'        : data['url'],
                 'name'       : data['name'],
                 'created_at' : data['created_at'],
                 'location'   : data['location'],
                 'description': data['description'],
                 'utc_offset' : data['utc_offset'],
                 'time_zone'  : data['time_zone'] }

    def get_user_info(self, auth_token, auth_verifier=''):
        auth_token = urlunquote(auth_token)
        auth_verifier = urlunquote(auth_verifier)
        auth_secret = memcache.get(self.make_memcache_authkey(auth_token))
        if not auth_secret:
            result = Session.SessionData.gql('WHERE twitter_oauth_token = :1 LIMIT 1', auth_token).get()
            if result: auth_secret = result.twitter_oauth_secret

        response = self.make_request(self.access_url,
                                     token=auth_token,
                                     secret=auth_secret,
                                     additional_params={'oauth_verifier': auth_verifier})
        result = self.extract_credentials(response)
        self.update_auth(result['token'], result['secret'])
        user_info = self.lookup_user_info(result['token'], result['secret'])
        return user_info


TwitterClient = TwitterOAuthClient
