var ct = {}; // namespace

ct.SVG = function() {
	try {
		this.element = document.createElementNS('http://www.w3.org/2000/svg', 'svg');
	} catch (e) {
		return;
	}
	// this.element.setAttribute('version', '1.1');
	// this.element.setAttribute('xmlns', 'http://www.w3.org/2000/svg'); 
	// this.element.setAttribute('xmlns:xlink', 'http://www.w3.org/1999/xlink');
}

ct.SVG.prototype.supported = function() {
	return this.element != null && typeof(this.element) != 'undefined';
}

ct.SVG.prototype.group = function(parent) {
	var el = document.createElementNS('http://www.w3.org/2000/svg', 'g');
	if (parent)
		parent.appendChild(el);
	else
		this.element.appendChild(el);
	return el;
}

ct.SVG.prototype.circle = function(cx, cy, r, o, parent) {
	var el = document.createElementNS('http://www.w3.org/2000/svg', 'circle');
	el.setAttribute('cx', cx);
	el.setAttribute('cy', cy);
	el.setAttribute('r', r);
	for (option in o)
		el.setAttribute(option, o[option]);
	if (parent)
		parent.appendChild(el);
	else
		this.element.appendChild(el);
	return el;
}

ct.SVG.prototype.xlink = function(uri) {
	var el = document.createElementNS('http://www.w3.org/2000/svg', 'a');
	el.setAttribute('xlink:href', uri);
	this.element.appendChild(el);
	return el;
}

ct.SVG.prototype.star = function(cx, cy, r, o, parent) {
	var el = document.createElementNS('http://www.w3.org/2000/svg', 'path');
	el.setAttribute('d', 'M0,1L0.22451398828979,0.30901699437495L0.95105651629515,0.30901699437495L0.36327126400268,-0.11803398874989L0.58778525229247,-0.80901699437495L0,-0.38196601125011L-0.58778525229247,-0.80901699437495L-0.36327126400268,-0.11803398874989L-0.95105651629515,0.30901699437495L-0.22451398828979,0.30901699437495Z');
	el.setAttribute('transform', 'translate(' + cx + ',' + cy + ')' + ' scale(' + r + ') rotate(180)');
	for (option in o)
		el.setAttribute(option, o[option]);
	if (o['stroke-width'])
		el.setAttribute('stroke-width', el.getAttribute('stroke-width') / r);
	if (parent)
		parent.appendChild(el);
	else
		this.element.appendChild(el);
	return el;
}

ct.SVG.prototype.line = function(x1, y1, x2, y2, o, parent) {
	var el = document.createElementNS('http://www.w3.org/2000/svg', 'line');
	el.setAttribute('x1', x1);
	el.setAttribute('y1', y1);
	el.setAttribute('x2', x2);
	el.setAttribute('y2', y2);
	for (option in o)
		el.setAttribute(option, o[option]);
	if (parent)
		parent.appendChild(el);
	else
		this.element.appendChild(el);
	return el;
}

ct.SVG.prototype.rect = function(x, y, w, h, o, parent) {
	var el = document.createElementNS('http://www.w3.org/2000/svg', 'rect');
	el.setAttribute('x', x);
	el.setAttribute('y', y);
	el.setAttribute('width', w);
	el.setAttribute('height', h);
	for (option in o)
		el.setAttribute(option, o[option]);
	if (parent)
		parent.appendChild(el);
	else
		this.element.appendChild(el);
	return el;
}

ct.SVG.prototype.text = function(x, y, fill, text, o, parent) {
	var el = document.createElementNS('http://www.w3.org/2000/svg', 'text');
	el.setAttribute('x', x);
	el.setAttribute('y', y);
	el.setAttribute('fill', fill);
	for (option in o)
		el.setAttribute(option, o[option]);
	var tx = document.createTextNode(text);
	el.appendChild(tx);
	if (parent)
		parent.appendChild(el);
	else
		this.element.appendChild(el);
	return el;
}
