﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;
using System.Xml.Linq;
using System.Diagnostics;

namespace RssReader2
{
    /// <summary>
    /// Interaktionslogik für MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
        }

        private void Window_Closing(object sender, System.ComponentModel.CancelEventArgs e)
        {
            // Settings speichern, damit sich die textBox1 die zuletzt eingegebene URL merkt.
            RssReader2.Properties.Settings.Default.Save();
        }

        private void button1_Click(object sender, RoutedEventArgs e)
        {
            button1.IsEnabled = false;
            Cursor oldCursor = this.Cursor;
            this.Cursor = Cursors.Wait; // Damit der Benutzer sieht, dass das dauern kann ...
            try
            {
                try
                {
                    List<RssItem> items = LoadFeed(textBox1.Text);
                    listBox1.ItemsSource = items;
                }
                catch (Exception ex)
                {
                    listBox1.ItemsSource = null;
                    MessageBox.Show(this, ex.ToString(), ex.Message);
                }
            }
            finally
            {
                this.Cursor = oldCursor;
                button1.IsEnabled = true;
            }
        }

        private List<RssItem> LoadFeed(string url)
        {
            if (!url.Contains(@"://"))
                url = @"http://" + url;
            var feed = XDocument.Load(url);
            var query = from item in feed.Descendants("item")
                        select new RssItem()
                        {
                            Title = item.Element("title").Value,
                            Description = item.Element("description").Value,
                            Url = item.Element("link").Value
                        };
            return query.ToList<RssItem>();
        }

        private void listBox1_MouseDoubleClick(object sender, MouseButtonEventArgs e)
        {
            RssItem item = listBox1.SelectedItem as RssItem;
            if (item != null && !string.IsNullOrEmpty(item.Url))
                Process.Start(item.Url);
        }

    }
}
