/*
 *
 * Beispiel zum Artikel "Indifferente Socken" c't 19/10, S. 160
 *
 * (c) 2010 Michael Stapelberg und c't
 *
 */

#ifdef WIN32
#include <WinSock2.h>
#include <ws2tcpip.h>
/* Das Windows-SDK enthlt die folgenden Funktionen nicht. Die Makros reichen fr dieses Beispielprogramm aus. */
#define warn(s)fputs(s, stderr)
#define err(e,s){fputs(s, stderr);WSACleanup();exit(e);}
/* Das hier funktioniert nur, weil errx in diesem Programm immer genau 3 Parameter bekommt. */
#define errx(e,s1,s2){fprintf(stderr,s1,s2);WSACleanup();exit(e);}
#else
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <unistd.h>
#include <err.h>
#endif
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

int main() {
#ifdef WIN32
	/* Winsock muss initialisiert werden. */
	WSADATA wsaData;
	if(WSAStartup(MAKEWORD(2, 2), &wsaData)){
		fputs("Winsock-Initialisierung fehlgeschlagen.", stderr);
		return 1;
	};
#endif

	struct addrinfo *res;
	struct addrinfo hints;
	memset(&hints, 0, sizeof(struct addrinfo));
	hints.ai_family = PF_UNSPEC;
	hints.ai_socktype = SOCK_STREAM;
	hints.ai_flags = AI_PASSIVE;
	int ret;
	if((ret = getaddrinfo(NULL, "49090", &hints, &res)) != 0)
		errx(EXIT_FAILURE, "getaddrinfo(): %s\n", gai_strerror(ret));

	int fd = 0, n = 0;
	#define NFDS 2
	int sockfds[NFDS];

	struct addrinfo *walk;
	for (walk = res; walk != NULL; walk = walk->ai_next) {
		fd = socket(walk->ai_family, walk->ai_socktype, walk->ai_protocol);
		if (fd == -1) {
			/* Hier kann eine Fehlermeldung hin, z.B. mit warn() */
			continue;
		}

		if (walk->ai_family == AF_INET6) {
			int on = 1;
			if (setsockopt(fd, IPPROTO_IPV6, IPV6_V6ONLY, (char*)&on, sizeof(on)) == -1) {
				/* Hier kann eine Fehlermeldung hin, z.B. mit warn() */
				continue;
			}
		}

		if (bind(fd, walk->ai_addr, walk->ai_addrlen)) {
			/* Hier kann eine Fehlermeldung hin, z.B. mit warn() */
			continue;
		}

		if (listen(fd, 5) == -1) {
			/* Hier kann eine Fehlermeldung hin, z.B. mit warn() */
			continue;
		}

		struct sockaddr_storage sa_stor;
		socklen_t sas = sizeof(sa_stor);
		struct sockaddr* sa = (struct sockaddr*) &sa_stor;
		if( getsockname(fd, sa, &sas))
			err( EXIT_FAILURE, "getsockname()");

		char hbuf[NI_MAXHOST], sbuf[NI_MAXSERV];
		int flags = NI_NUMERICHOST | NI_NUMERICSERV;
		if(getnameinfo( sa, sas, hbuf, sizeof(hbuf), sbuf, sizeof(sbuf), flags))
			err( EXIT_FAILURE, "getnameinfo()");


		printf("Lausche an %s, Port %s (fd %d)\n", hbuf, sbuf, fd);

		sockfds[n++] = fd;
		if(n>=NFDS)
			break;
	}
	freeaddrinfo(res);

	fd_set fds;
	int highest;
	while (1) {
		highest = 0;
		FD_ZERO(&fds);
		int i;
		for (i = 0; i < n; i++) {
			FD_SET(sockfds[i], &fds);
			highest = (sockfds[i] > highest ? sockfds[i] : highest);
		}
		ret = select(highest+1, &fds, NULL, NULL, NULL);
		if (ret == -1)
			err( EXIT_FAILURE, "select()");


		for (i = 0; i < n; i++) {
			if (!FD_ISSET(sockfds[i], &fds))
				continue;

			struct sockaddr_storage peer;
			socklen_t peers = sizeof(struct sockaddr_storage);
			int cfd = accept(sockfds[i], (struct sockaddr*)&peer, &peers);

			char buf[NI_MAXHOST];
			if (getnameinfo((struct sockaddr*)&peer, peers, buf, sizeof(buf), NULL, 0, NI_NUMERICHOST))
				err( EXIT_FAILURE, "getnameinfo()");

			printf("Neue Verbindung auf fd %d von %s\n", sockfds[i], buf);
#ifdef WIN32
			closesocket(cfd);
#else
			close(cfd);
#endif
		}
	}

#ifdef WIN32
	WSACleanup();
#endif
	return 0;
}
