/*
 *
 * Beispiel zum Artikel "Indifferente Socken" c't 19/10, S. 160
 *
 * (c) 2010 Michael Stapelberg und c't
 *
 */

#ifdef WIN32
#include <WinSock2.h>
#include <ws2tcpip.h>
/* Das Windows-SDK enthlt die folgenden Funktionen nicht. Die Makros reichen fr dieses Beispielprogramm aus. */
#define warn(s)fputs(s, stderr)
#define err(e,s){fputs(s, stderr);WSACleanup();exit(e);}
/* Das hier funktioniert nur, weil errx in diesem Programm immer genau 3 Parameter bekommt. */
#define errx(e,s1,s2){fprintf(stderr,s1,s2);WSACleanup();exit(e);}
#else
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <unistd.h>
#include <err.h>
#endif
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

int main(int argc, char **argv) {
#ifdef WIN32
	/* Winsock muss initialisiert werden. */
	WSADATA wsaData;
	if (WSAStartup(MAKEWORD(2, 2), &wsaData)){
		fputs("Winsock-Initialisierung fehlgeschlagen.", stderr);
		return 1;
	};
#endif

	struct addrinfo hints;
	memset(&hints, 0, sizeof(struct addrinfo));
	hints.ai_family = PF_UNSPEC;
	hints.ai_socktype = SOCK_STREAM;

	struct addrinfo *res;
	int ret;
	if ((ret = getaddrinfo("www.example.com", "http", &hints, &res))!=0)
		errx(EXIT_FAILURE, "getaddrinfo(): %s\n", gai_strerror(ret));

	int sockfd = -1;
	struct addrinfo *walk;
	for (walk = res; walk != NULL; walk = walk->ai_next) {
		sockfd = socket(walk->ai_family, walk->ai_socktype, walk->ai_protocol);
		if (sockfd < 0){
			/* Hier kann eine Fehlermeldung hin, z.B. mit warn() */
			continue;
		}
		if (connect(sockfd, walk->ai_addr, walk->ai_addrlen) != 0) {
#ifdef WIN32
			closesocket(sockfd);
#else
			close(sockfd);
#endif
			sockfd = -1;
			/* Hier kann eine Fehlermeldung hin, z.B. mit warn() */
			continue;
		}
		break;
	}

	freeaddrinfo(res);
	if (sockfd == -1)
		err( EXIT_FAILURE, "Keine Verbindung");

	struct sockaddr_storage sa_stor;
	socklen_t sas = sizeof(sa_stor);
	struct sockaddr* sa = (struct sockaddr*) &sa_stor;
	if( getpeername(sockfd, sa, &sas))
		err(EXIT_FAILURE, "getaddrinfo()");

	char hbuf[NI_MAXHOST], sbuf[NI_MAXSERV];
	int flags = NI_NUMERICHOST | NI_NUMERICSERV;
	if(getnameinfo( sa, sas, hbuf, sizeof(hbuf), sbuf, sizeof(sbuf), flags))
		errx(EXIT_FAILURE, "getnameinfo(): %s\n", gai_strerror(ret));

	printf("Verbunden mit Host %s, Port %s\n", hbuf, sbuf);

#ifdef WIN32
	WSACleanup();
#else
	close(sockfd);
#endif
	return 0;
}