// (c) 2010 Tobias Engler

// Event-Listener, der auf das message-Event der Global Page wartet; bei Eintreffen wird die Funktion handleSearchEvent() aufgerufen
safari.self.addEventListener("message", handleSearchEvent, false);

// Event-Listener, der auf das contextmenu-Event wartet; bei Eintreffen wird die Funktion handleContextMenu() aufgerufen
document.addEventListener("contextmenu", handleContextMenu, false);

function handleContextMenu(event)
{
	// Ausgewählten Text übernehmen und in event.userInfo zwischenspeichern
	var selection = document.getSelection().toString().trim();
	safari.self.tab.setContextMenuEventUserInfo(event, selection);
}

function handleSearchEvent(messageEvent)
{
	if (window.top === window)
	{
		// Wir befinden uns im Hauptfenster, nicht in einem IFRAME
		
		if (messageEvent.name === "search")
		{
			var hasOverlay = document.getElementById("heise_results_overlay");
			
			// Falls bereits ein Overlay existiert, nehmen wir dieses Element;
			// ansonsten erzeugen wir ein neues
			if (hasOverlay)
			{
				var heiseOverlay = hasOverlay;
			}
			else
			{
				var heiseOverlay = document.createElement("div");
				heiseOverlay.id = "heise_results_overlay";
		
				// Overlay-Element ins DOM einfügen
				document.body.insertBefore(heiseOverlay, document.body.firstChild);
			}
			
			// CSS-Einstellungen inklusive Transition
			heiseOverlay.style.cssText = "position: fixed; top: 20px; left: 20px; border: 2px dotted grey; background: #cccccc; color: red; a:color: grey; text-align: left; z-index: 9999; padding: 5px; -webkit-transition: opacity 3s; opacity: 0.95;";
			
			// Der Inline-Code ist notwendig, da die Webseite nicht auf den Namespace des injizierten Skripts zugreifen darf
			// messageEvent.message enthält das Suchergebnis
			heiseOverlay.innerHTML = "<span style='float:right; border: 1px solid grey; padding-left: 5px; padding-right: 5px; cursor: pointer;' onclick='javascript:var overlayElement = document.getElementById(\"heise_results_overlay\");overlayElement.style.opacity = \"0\"; setTimeout(\"var removedElement = document.body.removeChild(overlayElement);\", 3000);'>x</span>" + messageEvent.message;

		}
	}
}