#!/bin/sh

# Als root ausführen
if [ `id -u` -ne 0 ];then exec sudo $0; fi

# Hilfsfunktion, um Sicherungskopien zu erstellen
backup () {
  test -s $1 && cp $1 $1-`date +%Y%m%d-%H%M%S`-`stat -c '%G-%U-%a' $1`
}

# Die Linux-Rechner heißen "linux"
backup /etc/hostname
echo linux > /etc/hostname

apt-get install grub grub-doc
grub-install hd0

# Passwort für grub abfragen
echo 'Bitte gebe das Passwort für den Bootloader an.'
until PW=`openssl  passwd -1`; do 
  echo Noch einmal!
done

# Falls vorher GRUB 2 installiert war, wurde dort von grub-mkimage die Datei
# /boot/grub/core.img erstellt. Beim Uninstall von GRUB 2 wird
# diese nicht gelöscht, sodass sie als "Chainload" bei GRUB
# legacy eingetragen wird. Dieser Eintrag kann nicht automatisch gelockt werden,
# sodass dies möglicherweise ein Sicherheitsrisiko darstellt. Deswegen wird diese Datei einfach
# umbenannt.
dpkg -l grub >/dev/null && mv /boot/grub/core.img /boot/grub/core.img.orig

# Falls grub neu installiert wurde, muss erst einmal menu.lst erstellt werden.
if [ ! -f /boot/grub/menu.lst ];then
  update-grub
fi

# Den bootloader grub (legacy version) sicher machen.
perl -i-`date +%Y%m%d-%H%M%S` -p \
	-e "\$PW='$PW';" \
	-e '$/="";' \
	-e 's!^(# )?password[^\n]+\n(lock\n)?!password --md5 $PW\nlock\n!m;' \
	-e 's/^# lockalternative=.+/# lockalternative=true/m;' \
	-e 's/^# lockold=.+/# lockold=true/m;' \
	-e 's/^# howmany=.+/# howmany=7/m;' \
	-e 's/^# memtest86=.+/# memtest86=false/m;' /boot/grub/menu.lst

# Änderungen in der menu.lst wirksam werden lassen
update-grub

