#!/bin/bash
# Als root ausführen
if [ `id -u` -ne 0 ];then exec sudo $0; fi

# Einlesen der Release-Daten
. /etc/lsb-release

# Hilfsfunktion, um Sicherungskopien zu erstellen
function backup () {
  test -s $1 && cp $1 $1-`date +%Y%m%d-%H%M%S`-`stat -c '%G-%U-%a' $1`
}

deb_vbox="deb http://download.virtualbox.org/virtualbox/debian $DISTRIB_CODENAME non-free"

backup /etc/apt/sources.list
grep -q "$deb_vbox" /etc/apt/sources.list || apt-add-repository "$deb_vbox"
wget -q http://download.virtualbox.org/virtualbox/debian/oracle_vbox.asc -O- | apt-key add -
apt-get update

# ---->>> Binarie-Edition Versions-Nummer überprüfen.
# virtualbox=`apt-cache search --names-only virtualbox-[[:digit:]]\+.[[:digit:]]\+|sort|tail -1|awk '{print $1}'`
apt-get install virtualbox-3.2

usermod -a -G vboxusers keinpasswort
usermod -a -G vboxusers ladmin

