﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Content;

namespace FireBirds
{
    public class Enemy
    {
        //Variable für unsere Grafik
        public Texture2D texEnemy;
        
        //X,Y, Textur Breite und Höhe
        public Rectangle recEnemyPositionAndDimension;

        public void LoadContent(ContentManager Content, GraphicsDevice graphics)
        {
            //Die Konvertierte XNB Datei wird in texEnemy geladen
            texEnemy = Content.Load<Texture2D>("Graphics\\enemy");

            //Wir weisen unserer Variable eine Position und Grösse zu
            recEnemyPositionAndDimension.X = 0;
            recEnemyPositionAndDimension.Y = 0;
            recEnemyPositionAndDimension.Width  = texEnemy.Width;
            recEnemyPositionAndDimension.Height = texEnemy.Height;
        }

        

        public void Update()
        {
            //Der Gegner wir bei jedem aufruf um einen Pixel nach unten geschoben
            recEnemyPositionAndDimension.Y += 1;
        }

        public void Draw(SpriteBatch spriteBatch)
        {
            //Wir weisen die Stapelverarbeitung an unserer Grafik texEnemy, mit der Position und Dimension des recEnemyPositionAndDimension zu zeichnen
            spriteBatch.Draw(texEnemy, recEnemyPositionAndDimension, Color.White);
        }
    }
}
