﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Content;

namespace FireBirds
{
    public class Player
    {
        //Variable für unsere Grafik
        public Texture2D texPlayer;

        //X,Y, Textur Breite und Höhe
        public Rectangle recPlayerPositionAndDimension;
   
        public void LoadContent(ContentManager Content,GraphicsDevice graphics)
        {
            //Die Konvertierte XNB Datei wird in texEnemy geladen
            texPlayer = Content.Load<Texture2D>("Graphics\\spitfire");

            //Wir weisen unserer Variable eine Position und Grösse zu
            recPlayerPositionAndDimension.X = graphics.Viewport.Width / 2 - texPlayer.Width / 2;
            recPlayerPositionAndDimension.Y = graphics.Viewport.Height / 2 - texPlayer.Height / 2;
            recPlayerPositionAndDimension.Width = texPlayer.Width;
            recPlayerPositionAndDimension.Height = texPlayer.Height;
        }

        public void Update()
        {
            //Falls die Pfeiltaste nach oben gedrückt wurde, verschieben wir den Player in der Y Achse um eins nach oben
            if(Keyboard.GetState().IsKeyDown(Keys.Up))
            {
                recPlayerPositionAndDimension.Y -= 1;
            }

            //Falls die Pfeiltaste nach unten gedrückt wurde, verschieben wir den Player in der Y Achse um eins nach unten
            if (Keyboard.GetState().IsKeyDown(Keys.Down))
            {
                recPlayerPositionAndDimension.Y += 1;
            }

            //Falls die Pfeiltaste nach unten gedrückt wurde, verschieben wir den Player in der X Achse um eins nach links
            if (Keyboard.GetState().IsKeyDown(Keys.Left))
            {
                recPlayerPositionAndDimension.X -= 1;
            }

            //Falls die Pfeiltaste nach unten gedrückt wurde, verschieben wir den Player in der X Achse um eins nach rechts
            if (Keyboard.GetState().IsKeyDown(Keys.Right))
            {
                recPlayerPositionAndDimension.X += 1;
            }
        }

        public bool CheckCollision(Rectangle enemyPosition)
        {
            //Hier prüfen wir mit der Intersects Funktion, ob sich der Player mit dem Gegner Berührt
            if (recPlayerPositionAndDimension.Intersects(enemyPosition))
            {
                //Falls dies zutrifft, geben wir dem Hauptprogramm true zurück
                return true;
            }

            //Wenn nicht dann geben wir false zurück
            return false;
        }

        public void Draw(SpriteBatch spriteBatch)
        {
            //Wir weisen die Stapelverarbeitung an, unserer Grafik texEnemy, mit der Position und der Dimension welche sich in der Variable recEnemyPositionAndDimension befindet zu zeichnen
            spriteBatch.Draw(texPlayer, recPlayerPositionAndDimension, Color.White);
        }
    }


}
