using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;


namespace FireBirdsExtends
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        /// <summary>
        /// Variable welche unser Player.cs File reprsentiert
        /// Diese muss auch gleich mittels einer neuen Instanz geladen werden.
        /// </summary>
        Player player = new Player();


        /// <summary>
        /// Liste der Gegner
        /// </summary>
        List<Enemy> enemyList = new List<Enemy>();

        /// <summary>
        /// Liste der Gegner die gelscht werden sobald diese nicht mehr existieren. 
        /// </summary>
        List<Enemy> enemyListToDelete = new List<Enemy>();

        /// <summary>
        /// Liste der Bullets die gelscht werden sobald diese nicht mehr existieren. 
        /// </summary>
        public List<Bullet> bulletListToDelete = new List<Bullet>();


        /// <summary>
        /// Zufallszahl Generator
        /// </summary>
        Random randomGenerator = new Random();
        double timer;

        /// <summary>
        /// Variable welche unser File ScrollingBackground.cs reprsentiert
        /// </summary>
        ScrollingBackground scrollingBackground = new ScrollingBackground();

        /// <summary>
        /// SoundEffect Variable
        /// </summary>
        SoundEffect soundBackground;

        /// <summary>
        /// SoundEffectInstance wird gebraucht. Um dem Sound mitzuteilen, dass er sich stndig wiederholen soll. 
        /// </summary>
        SoundEffectInstance soundEffectInstance;


        /// <summary>
        /// Variable welche unser File GUI.cs reprsentiert
        /// </summary>
        GUI gui = new GUI();


        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";

            //Bildschirmgrsse wird auf 1280x720 gesetzt
            graphics.PreferredBackBufferWidth   = 1280;
            graphics.PreferredBackBufferHeight  = 720;
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            // TODO: Add your initialization logic here
            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // Create a new SpriteBatch, which can be used to draw textures.
            spriteBatch = new SpriteBatch(GraphicsDevice);
            
            //Background Sound wird geladen. 
            soundBackground = Content.Load<SoundEffect>("Sound\\FireBirds");
            
            //Wir erstellen von dem geladenen Sound eine Instanz und weisen die der soundEffectInstance Variable zu
            soundEffectInstance = soundBackground.CreateInstance();
            
            //Die Instanze wird auf Looped gesetzt, so wiederholt sich diese immer wieder
            soundEffectInstance.IsLooped = true;
            
            //Die Instanz wird zum abspielen aufgefordert. 
            soundEffectInstance.Play();
           
            //Der Content fr den Player, Background und das GUI wird geladen
            player.LoadContent(Content, GraphicsDevice);
            scrollingBackground.LoadContent(Content, GraphicsDevice);
            gui.LoadContent(Content, GraphicsDevice);

        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            if (Keyboard.GetState().IsKeyDown(Keys.Escape))
                Exit();

            // Wir addieren zu timer die verstrichene Zeit zwischen dem aktuellen und dem letzten Frame zu
            timer += gameTime.ElapsedGameTime.TotalSeconds;

            if (timer > 1.0)
            {
                timer = 0;

                //Ein neuer Gegner wird erstelle und der Liste hinzugefgt
                Enemy newEnemy = new Enemy();
                newEnemy.LoadContent(Content, GraphicsDevice);
                newEnemy.recEnemyPositionAndDimension.X = randomGenerator.Next(0, GraphicsDevice.Viewport.Width - newEnemy.texEnemy.Width/6);
                enemyList.Add(newEnemy);
            }

            player.Update(gameTime);

            //Wir lschen die beiden Listen welche uns dazu dienen nicht mehr gebrauchte Elemente zu lschen
            enemyListToDelete.Clear();
            bulletListToDelete.Clear();

            //Es wird jedes einzelne Element aus der Liste angewhlt
            foreach (Enemy enemy in enemyList)
            {

                if (!enemy.IsActive)
                {
                    //Sobald der Enemy nicht mehr Aktive ist, fgen wir diesen der ToDelete Liste zu. 
                    enemyListToDelete.Add(enemy);
                    
                    //Der Aktuellen Schleifendurchgang wird abgebrochen, da der Gegner als Inaktive Markiert wurde
                    continue;
                }
                 

                //Die Funktion Update in welcher wir den Player bewegen wird aufgerufen
                enemy.Update();

                //Wenn die Animation mit der Explosion Aktiv ist, brauchen wir ebenfalls keine Kollisionserkennung auszufhren. 
                if (enemy.showExplosion)
                    continue;


                //Wir rufen die Funktion CheckCollision in unsererm player auf und bergeben das aktuelle Rectangle von unsererm Gegner
                if (player.CheckCollision(enemy.recEnemyPositionAndDimension))
                {
                    //Unser Leben wird um 1 vermindert
                    gui.LiveCount -= 1;
                    
                    //Bei einer Kollision blenden wir die Explosionsanimation ein
                    enemy.ShowExplosion();
                }

                foreach (Bullet bullet in player.bulletList)
                {
                    if (!bullet.IsActive)
                    {
                        bulletListToDelete.Add(bullet);
                        continue;
                    }
                        
                    //Wir prfen, ob der Gegner mit einem Schuss aus der bulletList Kollidiert
                    if (enemy.CheckCollision(bullet.recBulletPositionAndDimension))
                    {
                        bullet.IsActive = false;
                        
                        //Wir erhhen unseren Score um einen Punkt
                        gui.IncreaseScore();
                    }
                }

            }

            scrollingBackground.Update();
            gui.Update();

            //Funktion welche alle nicht mehr bentigten Objekte lscht.            
            DeleteElementFromList();

            base.Update(gameTime);
        }

        /// <summary>
        /// In dieser Funktion lschen wir alle Inaktiven Elemente aus der Liste
        /// </summary>
        private void DeleteElementFromList()
        {
            //Wir durchlaufen jeden einzelnen Gegner in der enemyListToDelete Liste
            foreach (Enemy enemy in enemyListToDelete)
            {
                //Nun lschen wir das Inaktive Element von der Aktiven Gegnerliste
                enemyList.Remove(enemy);
            }

            //Wir durchlaufen jeden einzelnen Schuss in der bulletListToDelete Liste
            foreach (Bullet bullet in bulletListToDelete)
            {
                //Nun lschen wir das Inaktive Element von der Aktiven Schussliste
                player.bulletList.Remove(bullet);
            }
        }


        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.CornflowerBlue);

            //Der Kanal zur Grafikkarte wird geffnet
            spriteBatch.Begin();

            //Aufruf der Draw Funktion von unseren ScrollingBackground Objekt
            scrollingBackground.Draw(spriteBatch);

            player.Draw(spriteBatch);

            //Wir zeichnen jeden Gegner in der enemyList
            foreach (Enemy enemy in enemyList)
                enemy.Draw(spriteBatch);

            
            gui.Draw(spriteBatch);
            
            //Der Kanals zur Grafikkarte wird geschlossen
            spriteBatch.End();

            base.Draw(gameTime);
        }
    }
}
