#include <boost/asio.hpp>
#include <iostream>

using namespace boost::asio;

io_service ioservice;
deadline_timer timer1(ioservice);
deadline_timer timer2(ioservice);
deadline_timer timer3(ioservice);

void handler3(const boost::system::error_code &ec) {
  if (!ec)
     std::cout << "9 Sekunden sind rum." << std::endl;
}

void handler2(const boost::system::error_code &ec) {
  if (!ec)
     std::cout << "5 Sekunden sind rum." << std::endl;
}

void handler1(const boost::system::error_code &ec) {
  if (!ec) {
     std::cout << "3 Sekunden sind rum." << std::endl;
     timer3.expires_from_now(boost::posix_time::seconds(6));
     timer3.async_wait(handler3);
  }
}

int main() {
  std::cout << "Timer wird gestartet." << std::endl;
  timer1.expires_from_now(boost::posix_time::seconds(3));
  timer1.async_wait(handler);
  timer2.expires_from_now(boost::posix_time::seconds(5));
  timer2.async_wait(handler);
  ioservice.run();
  std::cin.get();
  return 0;
} 
