package com.linkesoft.bbingo;

import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;

import com.linkesoft.bbingo.BBingoDB.WordList;

/**
 * Bearbeite eine Wortliste, bestehend aus zwei EditText-Steuerelementen fr
 * Titel und Buzzwort-Liste (durch \n getrennt)  
 */
public class EditWordListFragment extends Fragment {
	private BBingoDB db;
	private EditText editTitle;
	private EditText editWords;
	private long id=0; // record ID des bearbeiteten Eintrags (0 fr neuen Eintrag), wird von der Activity gesetzt
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
	}
		
	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container,
			Bundle savedInstanceState) {
		View view=inflater.inflate(R.layout.editwordlist_fragment, container, false);
		editTitle = (EditText) view.findViewById(R.id.EditTitle);
		editWords = (EditText) view.findViewById(R.id.EditWords);		
		db = new BBingoDB(view.getContext()); 
		return view;
	}
		
	public void load(long id) {
		this.id=id;
		WordList wordlist = db.getWordList(id);
		editTitle.setText(wordlist.title);
		editWords.setText(wordlist.words);
		editWords.requestFocus();
	}
	
	public void save() {
		WordList wordlist = new WordList();
		wordlist.id = id;
		wordlist.title = editTitle.getText().toString().trim();
		wordlist.words = editWords.getText().toString().trim();
		if (wordlist.title.length() != 0 && wordlist.words.length() != 0) {
			id = db.setWordList(wordlist); // setze aktuelle ID (z.B. wenn eine
											// neue Wortliste gespeichert wird)
			Prefs.setID(getActivity(), id);
		}
	}
	
	@Override
	public void onResume() {
		super.onResume();
		if(id!=0)
			load(id);
	}
	
	@Override
	public void onPause() {
		super.onPause();
		// Daten speichern
		save();
	}
	
	@Override
	public void onDestroy() {
		db.close();
		super.onDestroy();
	}

}
