package com.linkesoft.bbingo;

import android.content.Intent;
import android.database.Cursor;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.view.ContextMenu;
import android.view.ContextMenu.ContextMenuInfo;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.AdapterView.AdapterContextMenuInfo;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.CursorAdapter;
import android.widget.ListView;
import android.widget.SimpleCursorAdapter;
import android.widget.Toast;

/**
 * Verwalte beliebig viele Wortlisten in einem ListView: Auswahl, Anlegen und Loeschen. 
 */
public class WordLists extends FragmentActivity {

	public static final String ID="id"; // Parameter zur Uebergabe der ausgewaehlten ID 
	private BBingoDB db;
	private ListView listView;

	@Override
	public void onCreate(Bundle savedInstanceState) {
	    super.onCreate(savedInstanceState);
	    setContentView(R.layout.wordlists);
	    listView = (ListView) findViewById(R.id.wordlist);
	
	    db = new BBingoDB(this);
	    Cursor cursor=db.getWordListsCursor(); // Cursor ueber alle Eintraege, wird vom ListAdapter verwaltet und geschlossen
	    listView.setAdapter(
	    		new SimpleCursorAdapter(this, 
	    			android.R.layout.simple_list_item_single_choice, // Layout fuer Listeneintrag
	    			cursor, 
	    			new String[]{BBingoDB.TITLE}, new int[]{android.R.id.text1}) // Mapping zwischen ID im Eintragslayout und Feld in der Datenbank
	    		);
	    registerForContextMenu(listView); // zeige popup menu fuer Liste
	    listView.setChoiceMode(ListView.CHOICE_MODE_SINGLE);
	    // whle aktuellen Eintrag aus
	    long id=Prefs.getID(this);
	    for(int position=0;position<listView.getCount();position++)
	    {
	    	if(id==listView.getItemIdAtPosition(position))
	    	{
	    		listView.setItemChecked(position, true);
	    		break;
	    	}
	    }
		EditWordListFragment editWordListFragment=(EditWordListFragment) getSupportFragmentManager().findFragmentById(R.id.EditWordListFragment);
		if(editWordListFragment!=null)
		{
			editWordListFragment.load(id);
		}
	    
	    listView.setOnItemClickListener(new OnItemClickListener() {
	    	/**
	    	 * Benutzer klickt auf einen Eintrag in der Liste
	    	 */

			@Override
			public void onItemClick(AdapterView<?> list, View v, int position,
					long id) {
				listView.setItemChecked(position, true);
				EditWordListFragment editWordListFragment=(EditWordListFragment) getSupportFragmentManager().findFragmentById(R.id.EditWordListFragment);
				if(editWordListFragment!=null)
				{
					editWordListFragment.save(); // sichere Aenderungen
					editWordListFragment.load(id);
					((CursorAdapter)listView.getAdapter()).getCursor().requery(); // frische Liste auf (z.B. Titel geaendert)
				}
				else if(id==Prefs.getID(WordLists.this)) // zweiter Klick auf Wordliste ffnet Editor als extra Aktivitt 
				{
					Intent intent = new Intent(WordLists.this, EditWordList.class);
					intent.putExtra(EditWordList.ID, id); // uebergebe aktuelle ID
					startActivity(intent);

				}
				Prefs.setID(WordLists.this, id);			
			}
		});
	}
	
	@Override
	protected void onResume() {
		((CursorAdapter)listView.getAdapter()).getCursor().requery(); // frische Liste auf    		
		super.onResume();
	}
	
	@Override
	protected void onDestroy() {
		db.close();
		super.onDestroy();
	}


/**
 * Erzeuge Context(Popup)-Menue, durch langen Tap auf einen Listeintrag ausgewaehlt
 */
	@Override
	public void onCreateContextMenu(ContextMenu menu, View v, ContextMenuInfo menuInfo) {
		if (v.equals(listView)) {
	        MenuInflater inflater = getMenuInflater();
	        inflater.inflate(R.menu.wordlists_context, menu);
	        AdapterContextMenuInfo info = (AdapterContextMenuInfo) menuInfo;
	        menu.setHeaderTitle(db.getWordList(info.id).title);
			return;
		}
		super.onCreateContextMenu(menu, v, menuInfo);
	}

/**
 * Context-Menue fuer List-Eintrag wurde durch Tap-and-Hold ausgewaehlt
 */
	@Override
	public boolean onContextItemSelected(MenuItem item) {
		AdapterContextMenuInfo info = (AdapterContextMenuInfo) item.getMenuInfo();
		switch(item.getItemId()) {
    	case R.id.delete:
    		db.removeWordList(info.id); // loesche Wortliste
    		// zeige Bestaetigung
    		Toast.makeText(this, R.string.WordListDeleted, Toast.LENGTH_SHORT).show();
    		((CursorAdapter)listView.getAdapter()).getCursor().requery(); // frische Liste auf 
    		break;
    	case R.id.edit:
			Intent intent = new Intent(this, EditWordList.class);
			intent.putExtra(EditWordList.ID, info.id); // uebergebe aktuelle ID
			startActivity(intent);
    		break;
		}
		return super.onContextItemSelected(item);
	}
// normales Menue zum Anlegen neuer Wortlisten und zum Importieren	
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.wordlists, menu);
		return super.onCreateOptionsMenu(menu);
	}
	
	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		switch(item.getItemId()) {
    	case R.id.add:
    		startActivity(new Intent(this,EditWordList.class)); // keine ID uebergeben = neue Wortliste
    		break;
		}
		return super.onOptionsItemSelected(item);
	}
	
}
