﻿Imports System.Diagnostics
Imports System.Windows.Forms

Public Class frmAction
    Public WPDocument As String = Nothing
    Public WPSender As String = Nothing

    Private Sub frmAction_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
        With Me
            .Text = modMain.APPNAME & " - Aktionen"

            ' Dokumentname anzeigen
            .lblDocument.Text = My.Computer.FileSystem.GetName(WPDocument)
            ' Absenderadresse anzeigen
            .lblSender.Text = WPSender
        End With
    End Sub

    Private Sub btnPrint_Click(sender As System.Object, e As System.EventArgs) Handles btnPrint.Click
        Try
            ' Parameter für Druckprozess festlegen
            Dim psi As New ProcessStartInfo
            With psi
                .UseShellExecute = True
                .Verb = "print"
                .WindowStyle = ProcessWindowStyle.Hidden
                .FileName = WPDocument
            End With

            Dim PrintProcess As New System.Diagnostics.Process
            With PrintProcess
                ' Parameter übergeben 
                .StartInfo = psi
                ' Prozess starten
                .Start()
                ' Auf Ende des Prozesses warten (damit Datei nicht vorher gelöscht wird)
                .WaitForExit()
                ' Aufräumen
                .Close()
            End With

            ' Im Fehlerfall...
        Catch ex As Exception
            ' ... Fehler melden
            MessageBox.Show("Beim Drucken des Dokuments ist ein Fehler aufgetreten.", modMain.APPNAME, MessageBoxButtons.OK, MessageBoxIcon.Error)
            ' Routine verlassen, damit User Dokument löschen oder speichern kann
            Return
        End Try

        With Me
            ' Dialogergebnis OK zurückgeben
            .DialogResult = Windows.Forms.DialogResult.OK
            ' Form schließen
            .Close()
        End With
    End Sub

    Private Sub btnSave_Click(sender As System.Object, e As System.EventArgs) Handles btnSave.Click
        ' Dialog konfigurieren
        With dlgSaveFile
            ' Dateinamen vorgeben
            .FileName = Me.lblDocument.Text
            ' Anfangsverzeichnis festlegen
            .InitialDirectory = My.Settings.LastFolder
            ' Warnen, wenn Datei schon existiert
            .OverwritePrompt = True

            ' Dialog anzeigen
            Dim DlgResult As DialogResult = .ShowDialog
            ' Wenn Dialog mit OK-Button beendet, dann...
            If DlgResult = Windows.Forms.DialogResult.OK Then
                Try
                    ' ... Dokument aus WP-Ordner an neuen Ort kopieren
                    My.Computer.FileSystem.CopyFile(WPDocument, .FileName, True)

                    ' Speicherordner in Settings sichern
                    With My.Settings
                        .LastFolder = My.Computer.FileSystem.GetParentPath(dlgSaveFile.FileName)
                        .Save()
                    End With

                    ' Im Fehlerfall...
                Catch ex As Exception
                    ' ... Fehler melden
                    MessageBox.Show("Beim Speichern des Dokuments ist ein Fehler aufgetreten.", modMain.AppName, MessageBoxButtons.OK, MessageBoxIcon.Error)
                    ' Routine verlassen, damit User Dokument drucken oder löschen kann
                    Return
                End Try

                ' Wenn Dialog abgebrochen, dann...
            Else
                ' ... Routine verlassen
                Return
            End If
        End With

        With Me
            ' Dialogergebnis OK zurückgeben
            .DialogResult = Windows.Forms.DialogResult.OK
            ' Form schließen
            .Close()
        End With
    End Sub

    Private Sub btnIgnore_Click(sender As System.Object, e As System.EventArgs) Handles btnIgnore.Click
        With Me
            ' Dialogergebnis Ignore zurückgeben
            .DialogResult = Windows.Forms.DialogResult.Ignore
            ' Form schließen
            .Close()
        End With
    End Sub

    Private Sub btnCancel_Click(sender As System.Object, e As System.EventArgs) Handles btnCancel.Click
        With Me
            ' Dialogergebnis Abbrechen zurückgeben
            .DialogResult = Windows.Forms.DialogResult.Cancel
            ' Form schließen
            .Close()
        End With
    End Sub
End Class