﻿Imports Microsoft.Office.Core

Module modCommandBar
    Public Function SymbolleisteFinden(ByVal SymName As String) As Office.CommandBar
        Dim GesuchteSymbolleiste As Office.CommandBar = Nothing

        Try
            'Alle Befehlsleisten des aktiven Explorers durchlaufen
            For Each Symbolleiste As Office.CommandBar In Globals.ThisAddIn.Application.ActiveExplorer.CommandBars
                'Wenn Befehlsleiste mit passendem Namen gefunden, dann...
                If Symbolleiste.Name.ToLower = SymName.ToLower Then
                    '... Verweis darauf in objGesuchteBefehlsleiste speichern
                    GesuchteSymbolleiste = Symbolleiste
                    Exit For
                End If
            Next
        Catch ex As Exception
        End Try

        ' Verweis auf (nicht) gefundene Befehlsleiste zurückgeben
        Return GesuchteSymbolleiste
    End Function

    Public Function SymbolleisteAnlegen(ByVal SymName As String, ByVal Temporär As Boolean) As Office.CommandBar
        Dim NeueSymbolleiste As Office.CommandBar = Nothing

        Try
            ' Verweis auf Symbolleiste holen
            Dim Symbolleiste = SymbolleisteFinden(SymName)

            ' Wenn diese existiert, dann...
            If Symbolleiste IsNot Nothing Then
                ' ... zunächst löschen
                Symbolleiste.Delete()
            End If

            ' Symbolleiste neu anlegen
            NeueSymbolleiste = Globals.ThisAddIn.Application.ActiveExplorer.CommandBars.Add(Name:=SymName, Temporary:=Temporär)
        Catch ex As Exception
        End Try

        ' Verweis auf neue Symbolleiste zurückgeben
        Return NeueSymbolleiste
    End Function

    Public Function SymbolleisteLeeren(ByVal Symbolleiste As Office.CommandBar) As Boolean
        Dim Erfolg As Boolean = False

        Try
            ' Alle Controls der Symbolleiste durchlaufen und...
            For Each Control As CommandBarControl In Symbolleiste.Controls
                ' ... jeweils löschen
                Control.Delete()

                ' Erfolg signalisieren
                Erfolg = True
            Next
        Catch ex As Exception
        End Try

        ' Ergebnis zurückgeben
        Return Erfolg
    End Function

    Public Function SymbolleisteLöschen(ByVal SymName As String) As Boolean
        Dim Erfolg As Boolean = False

        Try
            ' Verweis auf Symbolleiste holen
            Dim Symbolleiste = SymbolleisteFinden(SymName)

            ' Wenn diese existiert, dann...
            If Symbolleiste IsNot Nothing Then
                ' ... Symbolleiste löschen
                Symbolleiste.Delete()

                ' Erfolg signalisieren
                Erfolg = True

                ' Wenn diese NICHT existiert, dann...
            Else
                ' ... ebenfalls Erfolg signalisieren
                Erfolg = True
            End If
        Catch ex As Exception
        End Try

        ' Ergebnis zurückgeben
        Return Erfolg
    End Function

    Public Function ButtonAnlegen(ByVal Symbolleiste As Office.CommandBar, ByVal Style As MsoButtonStyle, ByVal Caption As String, ByVal FaceID As Integer, ByVal GruppeBeginnen As Boolean, ByVal Temporär As Boolean) As CommandBarButton
        Dim SymButton As CommandBarButton = Nothing

        Try
            ' Wenn Symbolleiste existiert, dann...
            If Symbolleiste IsNot Nothing Then
                ' ... Schaltfläche darauf anlegen
                SymButton = Symbolleiste.Controls.Add(Type:=MsoControlType.msoControlButton, Temporary:=Temporär)
                With SymButton
                    ' Gruppe beginnen (oder nicht)
                    .BeginGroup = GruppeBeginnen
                    ' Stil festlegen
                    .Style = Style
                    ' Beschriftung festlegen
                    .Caption = Caption
                    ' Grafisches Symbol festlegen
                    .FaceId = FaceID
                End With
            End If
        Catch ex As Exception
        End Try

        ' Verweis auf Schaltfläche zurückgeben
        Return SymButton
    End Function
End Module
