﻿Imports System.Windows.Forms

Public Class ThisAddIn
    Public WithEvents WebPrintTimer As New Timer

    ' ****************************************************************
    ' Add-in-Ereignisroutinen
    ' ****************************************************************

    Private Sub ThisAddIn_Startup() Handles Me.Startup
        ' Wenn Outlook 2007, dann...
        If GetOutlookVersion() < 14 Then
            ' ... Symbolleiste anlegen bzw. reaktivieren
            Call SymInit()
        End If
    End Sub

    Private Sub ThisAddIn_Shutdown() Handles Me.Shutdown
        ' Wenn Outlook 2007, dann...
        If GetOutlookVersion() < 14 Then
            ' ... Symbolleiste löschen
            Call modMain.SymExit()
        End If
    End Sub

    Protected Overrides Function CreateRibbonExtensibilityObject() As Microsoft.Office.Core.IRibbonExtensibility
        Return New modRibbon()
    End Function

    ' ****************************************************************
    ' Outlook-Ereignisroutinen
    ' ****************************************************************

    ' Beim Eintreffen einer neuen Nachricht...
    Private Sub Application_NewMailEx(EntryIDCollection As String) Handles Application.NewMailEx
        Dim EntryIDs As String()
        Dim NewItem As Object
        Dim i As Integer

        ' ... übergebenes Array mit EntryIDs aufsplitten
        ' (tatsächlich übergibt das NewMailEx-Ereignis immer nur eine EntryID,
        ' da es im Gegensatz zu NewMail für jede neue Mail ausgelöst wird)
        EntryIDs = Split(EntryIDCollection, ",")
        ' Alle Array-Elemente durchlaufen
        For i = 0 To UBound(EntryIDs)
            ' Verweis auf neu empfangenes Element holen
            NewItem = Application.Session.GetItemFromID(EntryIDs(i))

            ' Wenn Element eine Nachricht ist, dann...
            If TypeName(NewItem) = "MailItem" Then
                ' ... typsicheren Verweis anlegen
                Dim NewMail As Outlook.MailItem = CType(NewItem, Outlook.MailItem)

                ' Wenn Mail-Betreff WebPrint-typisch ist, dann...
                If LCase(NewMail.Subject) = LCase(AppSubject) Then
                    ' ... Pfad des Speicherordners ermitteln (WebPrint-Ordner/Absender-Mail-Adresse)
                    Dim SenderFolder = My.Computer.FileSystem.CombinePath(modMain.GetWPFolder, NewMail.SenderEmailAddress)

                    ' Alle Anhänge dort speichern. Wenn dabei kein Fehler aufgetreten ist, dann...
                    If modMain.SaveAttachments(NewMail, SenderFolder) = True Then
                        ' ... Nachricht löschen (in Ordner "Gelöschte Objekte" verschieben)
                        NewMail.Delete()

                        ' Timer initialisieren (startet Behandlungsroutine mit Zeitverzögerung, um möglichst alle 
                        ' empfangenen WebPrint-Mails auf einmal zu drucken/speichern)
                        With WebPrintTimer
                            ' Verzögerung: 5 Sekunden nach Erhalt dieser Nachricht 
                            ' (da der Timer von jeder weiteren WebPrint-Mail neu gestartet wird, startet 
                            ' die Behandlungsroutine effektiv 5 Sekunden nach Empfang der LETZTEN WebPrint-Mail)
                            .Interval = 5000
                            ' Timer starten
                            WebPrintTimer.Start()
                        End With
                    End If
                End If
            End If
        Next
    End Sub

    ' ****************************************************************
    ' Timer-Ereignisroutinen
    ' ****************************************************************

    ' Beim Ablauf des Timer-Intervalls...
    Private Sub WebPrintTimer_Tick(sender As Object, e As System.EventArgs) Handles WebPrintTimer.Tick
        ' ... Timer stoppen
        WebPrintTimer.Stop()

        ' Behandlungsroutine aufrufen
        Call modMain.HandleWPDocuments()
    End Sub
End Class
