﻿Imports System.Net.Mail

Public Class frmMain
    Private WithEvents myMailServer As System.Net.Mail.SmtpClient
    Private mySendingMail As Boolean = False
    Private myMruListDocuments As New System.Collections.Specialized.StringCollection
    Private myMruListRecipients As New System.Collections.Specialized.StringCollection
    Private myMruMaxEntries As Integer = 8
    Private myBatchMode As Boolean = False
    Private myErrorLevel As Int32 = 1

    Private Sub frmMain_Load(sender As Object, e As System.EventArgs) Handles Me.Load
        With Me
            ' Formtitel festlegen
            .Text = AppName

            With .nicIcon
                ' Text des Tray-Icons festlegen
                .Text = AppName
                ' Icon anzeigen
                .Visible = True
            End With

            ' MRU-Liste "Dokument" aus Settings einlesen und... 
            myMruListDocuments = String2StringCollection(My.Settings.MruListDocument, "*")
            ' ... in cmbDocument übertragen
            Call MruUpdateComboBox(cmbDocument, myMruListDocuments)

            ' MRU-Liste "Empfänger" aus Settings einlesen und... 
            myMruListRecipients = String2StringCollection(My.Settings.MruListRecipient, "*")
            ' ... in cmbRecipient übertragen
            Call MruUpdateComboBox(cmbRecipient, myMruListRecipients)

            ' Alle Befehlszeilenargumente durchlaufen
            For Each Arg As String In My.Application.CommandLineArgs
                Select Case Arg.ToLower
                    ' Wenn Argument "/B" ist, dann...
                    Case "/b"
                        ' ... Batch-Modus aktivieren
                        myBatchMode = True

                        ' Ansonsten...
                    Case Else
                        ' ... prüfen, ob es mit "/R:" beginnt. Wenn ja, dann...
                        If Arg.ToLower.StartsWith("/r:") Then
                            '  ... den Text dahinter in cmbRecipient übernehmen
                            .cmbRecipient.Text = Arg.Substring(3)

                            ' Ansonsten...
                        Else
                            ' ... Argument in cmbDocument übernehmen
                            .cmbDocument.Text = Arg
                        End If
                End Select
            Next

            ' Wenn kein Empfänger per Parameter angegeben, dann...
            If .cmbRecipient.Text = "" Then
                ' ... Adresse des Standardempfängers aus Settings lesen
                .cmbRecipient.Text = My.Settings.RecipientAddress
            End If
        End With

        ' Control-Status aktualisieren
        Call ControlStatus()
    End Sub

    Private Sub frmMain_Shown(sender As Object, e As System.EventArgs) Handles Me.Shown
        ' Wenn OK-Button aktiv und Batch-Modus aktiviert ist, dann...
        If Me.btnOK.Enabled = True And myBatchMode = True Then
            ' ... Klick auf OK-Button simulieren
            Call btnOK_Click(sender, e)
        End If
    End Sub

    Private Sub cmbDocument_TextChanged(sender As System.Object, e As System.EventArgs) Handles cmbDocument.TextChanged
        ' Control-Status aktualisieren
        Call ControlStatus()
    End Sub

    Private Sub cmbRecipient_TextChanged(sender As Object, e As System.EventArgs) Handles cmbRecipient.TextChanged
        ' Control-Status aktualisieren
        Call ControlStatus()
    End Sub

    Private Sub btnFile_Click(sender As System.Object, e As System.EventArgs) Handles btnDocument.Click
        Dim DateiDialog As New OpenFileDialog
        With DateiDialog
            ' Alle Dateitypen wählbar
            .Filter = "Alle Dateien (*.*)|*.*"
            .FilterIndex = 0
            ' Zuletzt aktiver Ordner bleibt eingestellt!!
            .RestoreDirectory = True

            ' Dialog anzeigen. Wenn mit OK beendet, dann...
            If .ShowDialog() = DialogResult.OK Then
                ' ... Pfadnamen der gewählten Datei in cmbSourceFile übernehmen
                Me.cmbDocument.Text = .FileName
            End If
        End With
    End Sub

    Private Sub lnkSettings_LinkClicked(sender As System.Object, e As System.EventArgs) Handles lnkSettings.LinkClicked
        ' Einstellungen-Dialogfeld anzeigen
        ShowSettingsDialog()
    End Sub

    Private Sub lnkInfo_LinkClicked(sender As System.Object, e As System.EventArgs) Handles lnkInfo.LinkClicked
        ' Info-Dialog anzeigen
        Dim DlgInfo As New frmInfo
        With DlgInfo
            .Text = "Info"
            .ShowDialog()
        End With
    End Sub

    Private Sub btnOK_Click(sender As System.Object, e As System.EventArgs) Handles btnOK.Click
        ' Wenn die notwendigen Einstellungen NICHT vorhanden sind, dann...
        If SettingsValid() = False Then
            ' ... Einstellungen-Dialog anzeigen. Wenn dieser abgebrochen wird, dann...
            If ShowSettingsDialog() = Windows.Forms.DialogResult.Cancel Then
                ' ... Prozedur verlassen
                Return
            End If
        End If

        ' Start des Mail-Versands signalisieren
        mySendingMail = True
        ' Control-Status aktualisieren
        Call ControlStatus()

        Try
            ' Pfadnamen der Anhang-Datei aus Form lesen
            Dim AttachmentFile As String = Me.cmbDocument.Text
            ' Empfängeradresse aus Form lesen
            Dim Recipient As String = Me.cmbRecipient.Text
            ' Neue Mail anlegen
            Dim WebPrintMail As MailMessage = New MailMessage()

            ' Mail konfigurieren
            With WebPrintMail
                ' Empfänger hinzufügen
                .To.Add(Recipient)
                ' Absender hinzufügen
                .From = New MailAddress(My.Settings.SenderAddress)
                ' Betreff festlegen
                .Subject = AppName & "-Mail"
                ' Nachrichtentext festlegen
                .Body = "Dies ist eine automatisch generierte " & AppName & "-Mail von " & My.User.Name & "." & vbCr & vbCr _
                    & "Dokument: " & My.Computer.FileSystem.GetName(AttachmentFile)
                ' Übergebene Datei als Anhang hinzufügen
                .Attachments.Add(New Attachment(AttachmentFile))
            End With

            ' Verbindung zum Postausgangsserver aufnehmen (Name aus Settings)
            myMailServer = New SmtpClient(My.Settings.SMTPServer)
            With myMailServer
                ' Port aus Settings übernehmen
                .Port = CInt(My.Settings.Port)
                ' Benutzername und Kennwort aus Settings übergeben
                .Credentials = New System.Net.NetworkCredential(My.Settings.Username, My.Settings.Password)

                ' Mail asynchron versenden
                .SendAsync(WebPrintMail, Me)
            End With

        Catch ex As Exception
            ' Ende des Mail-Versands signalisieren
            mySendingMail = False
            ' Control-Status aktualisieren
            Call ControlStatus()

            ' Fehlermeldung anzeigen
            MessageBox.Show(ex.Message, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Error)
        End Try
    End Sub

    Private Sub btnCancel_Click(sender As System.Object, e As System.EventArgs) Handles btnCancel.Click
        ' Form schließen
        Me.Close()
    End Sub

    Private Sub frmMain_FormClosed(sender As Object, e As System.Windows.Forms.FormClosedEventArgs) Handles Me.FormClosed
        ' Wenn Mail-Versand erfolgreich abgelaufen, dann...
        If myErrorLevel = 0 Then
            ' ... Pfadnamen der gesendeten Datei in MRU-Liste speichern
            SaveToMruList(myMruListDocuments, Me.cmbDocument.Text, myMruMaxEntries)
            ' Empfänger in MRU-Liste speichern
            SaveToMruList(myMruListRecipients, Me.cmbRecipient.Text, myMruMaxEntries)

            ' MRU-Liste in Settings speichern
            With My.Settings
                .MruListDocument = StringCollection2String(myMruListDocuments, "*")
                .MruListRecipient = StringCollection2String(myMruListRecipients, "*")
                .Save()
            End With
        End If

        ' Tray-Icon löschen
        nicIcon.Dispose()

        ' ErrorLevel als Exit-Code setzen
        Environment.Exit(myErrorLevel)
    End Sub

    ' ******************************************************************************************
    ' Routinen
    ' ******************************************************************************************

    Private Function ShowSettingsDialog() As DialogResult
        Dim Result As DialogResult

        ' frmSettings als Dialogfeld anzeigen
        Dim DlgSettings As New frmSettings
        With DlgSettings
            .Text = "Einstellungen"
            Result = .ShowDialog()
        End With

        ' Dialogergebnis zurückgeben
        Return Result
    End Function

    Private Function SettingsValid() As Boolean
        ' Server-Name, Absender- und Empfängeradresse müssen mindestens bekannt sein
        Return My.Settings.SMTPServer > "" AndAlso My.Settings.RecipientAddress > "" AndAlso My.Settings.SenderAddress > ""
    End Function

    Private Sub ControlStatus()
        With Me
            ' cmbDocument und andere Controls (de)aktivieren, je nachdem, ob Mail-Übertragung läuft oder nicht 
            .cmbDocument.Enabled = Not mySendingMail
            .cmbRecipient.Enabled = Not mySendingMail

            ' btnOK nur aktivieren, wenn Mail-Übertragung NICHT läuft, die in cmbDocument 
            ' angegebene Datei existiert und eine Empfängeradresse angegeben ist
            .btnOK.Enabled = Not mySendingMail AndAlso _
                My.Computer.FileSystem.FileExists(.cmbDocument.Text) = True AndAlso .cmbRecipient.Text > ""
        End With
    End Sub

    ' ******************************************************************************************
    ' Ereignisroutinen myMailServer
    ' ******************************************************************************************

    Private Sub myMailServer_SendCompleted(sender As Object, e As System.ComponentModel.AsyncCompletedEventArgs) Handles myMailServer.SendCompleted
        ' Form zunächst nur verbergen
        Me.Hide()

        ' Erfolgsmeldung im Tray-Icon anzeigen
        With nicIcon
            .BalloonTipIcon = ToolTipIcon.Info
            .BalloonTipTitle = AppName
            .BalloonTipText = "Dokument gesendet."
            .ShowBalloonTip(5000)
        End With

        ' Erfolgreichen Versand signalisieren
        myErrorLevel = 0

        ' 4 Sekunden pausieren, damit Tray-Icon-Botschaft lesbar ist
        System.Threading.Thread.Sleep(4000)

        ' Dann Form schließen
        Me.Close()
    End Sub
End Class
