﻿Public Class frmSettings
    Private Const PROGPARM As String = Chr(34) & "<OutputFilename>" & Chr(34) & " /b"

    Private Sub frmSettings_Load(sender As Object, e As System.EventArgs) Handles Me.Load
        'Einstellungen aus Settings lesen
        With Me
            .txtRecipient.Text = My.Settings.RecipientAddress
            .txtSender.Text = My.Settings.SenderAddress

            With .chkLinkedToPDFCreator
                'Checkbox nur aktivieren, wenn PDFCreator installiert ist
                .Enabled = GetPDFCreatorInstalled()

                'Wenn Checkbox aktiviert, dann...
                If .Enabled Then
                    '... nur einschalten, wenn WebPrint als "Aktion nach dem Speichern"
                    'in PDFCreator eingetragen
                    .Checked = GetLinkStatus()
                End If
            End With

            .txtServer.Text = My.Settings.SMTPServer
            .txtPort.Text = My.Settings.Port
            .txtUsername.Text = My.Settings.Username
            .txtPassword.Text = My.Settings.Password
        End With

        'Control-Status aktualisieren
        Call ControlStatus()
    End Sub

    Private Sub TextBoxes_TextChanged(sender As System.Object, e As System.EventArgs) Handles _
        txtServer.TextChanged, txtUsername.TextChanged, txtPassword.TextChanged, _
        txtRecipient.TextChanged, txtPort.TextChanged, txtSender.TextChanged

        'Control-Status aktualisieren
        Call ControlStatus()
    End Sub

    Private Sub btnOK_Click(sender As System.Object, e As System.EventArgs) Handles btnOK.Click
        'Wenn Checkbox aktiviert, dann...
        If chkLinkedToPDFCreator.Enabled = True Then
            '... prüfen, ob Checkbox eingeschaltet ist. Wenn ja, dann...
            If chkLinkedToPDFCreator.Checked = True Then
                '... WebPrint als "Aktion nach dem Speichern" in PDFCreator-Einstellungen eintragen
                modMain.HKCU_ValueSchreiben(RegSubKeyName_PDFCreator, RegValueName_RunProg, "1")
                modMain.HKCU_ValueSchreiben(RegSubKeyName_PDFCreator, RegValueName_PName, GetMyProgPathName)
                modMain.HKCU_ValueSchreiben(RegSubKeyName_PDFCreator, RegValueName_PParms, PROGPARM)

                'Wenn Checkbox ausgeschaltet ist, dann...
            Else
                '... WebPrint aus PDFCreator-Einstellungen entfernen
                modMain.HKCU_ValueSchreiben(RegSubKeyName_PDFCreator, RegValueName_PParms, "")
                modMain.HKCU_ValueSchreiben(RegSubKeyName_PDFCreator, RegValueName_PName, "")
                modMain.HKCU_ValueSchreiben(RegSubKeyName_PDFCreator, RegValueName_RunProg, "0")
            End If
        End If

        'Control-Einstellungen in Settings schreiben
        With My.Settings
            .RecipientAddress = Me.txtRecipient.Text
            .SenderAddress = Me.txtSender.Text
            .SMTPServer = Me.txtServer.Text
            .Port = IIf(Val(Me.txtPort.Text) = 0, "25", Me.txtPort.Text)
            .Username = Me.txtUsername.Text
            .Password = Me.txtPassword.Text
            .Save()
        End With

        'Form schließen
        Me.Close()
    End Sub

    Private Sub btnCancel_Click(sender As System.Object, e As System.EventArgs) Handles btnCancel.Click
        'Form schließen
        Me.Close()
    End Sub

    '******************************************************************************************
    'Routinen
    '******************************************************************************************

    Private Sub ControlStatus()
        With Me
            'OK-Button nur aktivieren, wenn zumindest Empfänger, Absender und Server angegeben sind
            .btnOK.Enabled = .txtServer.Text > "" And .txtRecipient.Text > "" And .txtSender.Text > ""
        End With
    End Sub

    Private Function GetPDFCreatorInstalled() As Boolean
        'TRUE, wenn in den PDFCreator-Einstellungen der Reg-Wert "Language" existiert
        Return modMain.HKCU_ValueLesen(RegSubKeyName_PDFCreator, RegValueName_Language, "") > ""
    End Function

    Private Function GetMyProgPathName() As String
        'Pfadnamen von WebPrint zurückgeben
        Return My.Computer.FileSystem.CombinePath _
            (My.Application.Info.DirectoryPath, My.Application.Info.AssemblyName & ".exe")
    End Function

    Private Function GetLinkStatus() As Boolean
        'Nur TRUE, wenn alle PDFCreator-Einstellungen aktiv sind, die WebPrint 
        'als "Aktion nach dem Speichern" eintragen
        Return modMain.HKCU_ValueLesen(RegSubKeyName_PDFCreator, RegValueName_RunProg, "") = "1" AndAlso _
            modMain.HKCU_ValueLesen(RegSubKeyName_PDFCreator, RegValueName_PName, "") = GetMyProgPathName() AndAlso _
            modMain.HKCU_ValueLesen(RegSubKeyName_PDFCreator, RegValueName_PParms, "") = PROGPARM
    End Function
End Class