/*
 *  Hand.h
 *  Gesture Library
 *
 *  Created by Andy Abgottspon on 20.01.10.
 *  Copyright 2010 aaweb. All rights reserved.
 *
 */

#ifndef HAND_H
#define HAND_H

#include "ofMain.h"
#include "ofxOpenCv.h"
#include "ofxVectorMath.h"

class Hand {
    
public: 
    Hand();  
    void                    draw(bool debug = false);
    ofPoint                 getPosition();
    ofRectangle             getRect() { return vRectangle[vRectangle.size()-1]; } 
    int                     getGesture() { return gesture; }
    int                     getGestureType() { return gestureType; }
    void                    setBlob(ofxCvBlob *bl);
    ofxCvBlob*              getBlob() { return blob; };
    int                     findGesture();
    
    char                    gestureStr[1024];
    char                    debugStr[1024];
    int                     id;
    int                     contourInd;
    int                     gesture;
    int                     gestureType;
    ofPoint				    position;
    vector<ofPoint>		    vPosition;
    vector<ofRectangle>     vRectangle;    
    vector<int>             vGesture;    
    ofxCvBlob*              blob;
};

#endif
	    