/*
 *  Hand.cpp
 *  Gesture Library
 *
 *  Created by Andy Abgottspon on 20.01.10.
 *  Copyright 2010 aaweb. All rights reserved.
 *
 */

#include "GestureLibrary.h"
#include "Hand.h"

Hand::Hand() 
{
    gesture = GEST_NONE;   
}

//--------------------------------------------------------------
void Hand::setBlob(ofxCvBlob *bl)
{
    blob = bl;
    position = blob->centroid;
    vPosition.push_back(blob->centroid);
    vRectangle.push_back(blob->boundingRect);
}

//--------------------------------------------------------------
ofPoint Hand::getPosition()
{
    ofPoint p = (vPosition.size() > 1) ? vPosition[vPosition.size()-1] : NULL; 
    return p;
}

//--------------------------------------------------------------
int Hand::findGesture() 
{
	float tolAngle = 20;
	float maxHandDistance = 20; // the maximum distance the hand is considered still

	// Draw history of hand positions
	int start = (vPosition.size() > GESTLIB_HISTORY_STEPS) ? vPosition.size()-1-GESTLIB_HISTORY_STEPS : 0;

    // Get resize factor
    float handResize = 1 / vRectangle[start].height * vRectangle[vPosition.size()-1].height;


	// Get direction and angle
    ofxVec2f handDir = ofxVec2f(vPosition[vPosition.size()-1].x-vPosition[start].x, 
                                vPosition[vPosition.size()-1].y-vPosition[start].y);
    float distance = handDir.length();
	float angle = handDir.angle(ofxVec2f(0,1));
	float angleAbs = (angle < 0) ? -angle : angle; // abs
	
	
	/*
	 * Gesture decision start
	 */
	ofSetColor(0, 255, 0);
    
    //
    // LOOK FOR GESTURE END
    //
    // If gesture in progress, wait for it to end, don't allow other gestures
    if(gestureType == GEST_TYPE_INPROGRESS) {
        
        if((gesture == GEST_SWIPE_LEFT || gesture == GEST_SWIPE_RIGHT) && 
            distance/2 < maxHandDistance) 
        {
			gestureType = GEST_TYPE_DEFAULT;
        } 
        else if(gesture == GEST_GRAB && handResize > 0.9 && handResize < 1.1) 
        {
            gestureType = GEST_TYPE_DEFAULT;
            // printf("\nAA: END GRAB");
        }
        else if(gesture == GEST_RELEASE && handResize > 0.9 && handResize < 1.1) 
        {
            gestureType = GEST_TYPE_DEFAULT;
        }
    }     
    //
    // LOOK FOR GESTURE START
    // if gestureType is DEFAULT
    //
    else {
    	// Swipes
    	if(handDir.length() > GESTLIB_MIN_SWIPE_SIZE && 
    	    angleAbs >= 90-tolAngle && angleAbs <= 90+tolAngle) {

    		if(angle < 0) {
    			sprintf(gestureStr, "<<");
    			gesture = GEST_SWIPE_LEFT;
    		}
    		else {
    			sprintf(gestureStr, ">>");
    			gesture = GEST_SWIPE_RIGHT;
    		}
			gestureType = GEST_TYPE_INPROGRESS;
    	}
    	// Grab
    	else if(distance < GESTLIB_MAX_GRAB_RELEASE_RADIUS && 
    	    handResize < 1.0 - GESTLIB_GRAB_TOLERANCE) {
    		sprintf(gestureStr, "Grab");
            // printf("\nAA: START GRAB");
    		gesture = GEST_GRAB;
			gestureType = GEST_TYPE_INPROGRESS;
    	}
    	// Release
    	else if(distance < GESTLIB_MAX_GRAB_RELEASE_RADIUS && 
    	    handResize > 1.0 + GESTLIB_GRAB_TOLERANCE) {
    		sprintf(gestureStr, "Release");
    		gesture = GEST_RELEASE;
			gestureType = GEST_TYPE_INPROGRESS;
    	}     
    	// No gesture
    	else {
    		ofSetColor(0xffffff);
    		sprintf(gestureStr, "No gesture");
            gesture = GEST_NONE;
			gestureType = GEST_TYPE_DEFAULT;
    	}       
    }
    
	/*
	 * Gesture decision end
	 */	
    //ofDrawBitmapString(gestureStr, 0, imgSize.y+10);
                 
    // Save gesture to history
    vGesture.push_back(gesture);
    
	
	// Draw debug stuff
	ofSetColor(0xffffff);
    sprintf(debugStr, "%s, Dir Length %6.2f angle: %6.2f Hand-Res: %6.2f", 
			gestureStr, handDir.length(), angle, handResize
			);
    //ofDrawBitmapString(gestureStr, 0, imgSize.y+20);
    
    //printf("\nHand");
	
	return gesture;
}	

//--------------------------------------------------------------
void Hand::draw(bool debug) 
{
    // Draw gesture string if there is a gesture
    if(gesture != GEST_NONE) {
        if(gestureType == GEST_TYPE_INPROGRESS)
            ofSetColor(0xFFFF00); // yellow
        else
            ofSetColor(0,255,0); // green
            
        ofDrawBitmapString(gestureStr, position.x+10, position.y+10);
    }
                                   
    int cursorSize = 2;
    if(gestureType == GEST_TYPE_INPROGRESS) {
        ofSetColor(0x00FF00);
        cursorSize = 5;
    } else {
        ofSetColor(0xFFFFFF); // white
    }                        
    
    // Draw center/cursor
    ofFill();
    ofCircle(position.x, position.y, cursorSize);
    // ofSetColor(255, 255, 255);

    if(debug) {
        char number_str[10];
        sprintf(number_str, "%d", id);
        ofSetColor(0xCCCCCC);
        ofDrawBitmapString(number_str, position.x-10, position.y+10);
    }    
}
