# ct_checkbackup.ps1 (c) c't/Peter Siering, GPLv3
# Prueft, ob Erfolgsmeldung der Windows Server
# Sicherung im Ereignisprotokoll ist, um andernfalls
# mit Nagios Alarm zu schlagen
# Weitere Hinweise in c't 12/2012, S. 184

$date=(get-date)-(New-TimeSpan -hour 24)
$eventcount=Get-WinEvent -FilterHashTable @{ LogName = 
'Microsoft-Windows-Backup'; ID=4; starttime=$date } `
-EA SilentlyContinue | Measure-Object
if ( $eventcount.Count -eq 0 ) { "FAIL - Backup did not run"; exit 2 }
"OK - Backup did run"; exit 0