// Stepper.cpp: Implementierung der Klasse CStepper.
//
//////////////////////////////////////////////////////////////////////

/*
	COPYRIGHT 2011 Christian Nolte
    
    This file is part of myengrave.

    myengrave is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    myengrave is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with myengrave.  If not, see <http://www.gnu.org/licenses/>.

    Diese Datei ist Teil von myengrave.

    myengrave ist Freie Software: Sie knnen es unter den Bedingungen
    der GNU General Public License, wie von der Free Software Foundation,
    Version 3 der Lizenz oder (nach Ihrer Option) jeder spteren
    verffentlichten Version, weiterverbreiten und/oder modifizieren.

    myengrave wird in der Hoffnung, dass es ntzlich sein wird, aber
    OHNE JEDE GEWHELEISTUNG, bereitgestellt; sogar ohne die implizite
    Gewhrleistung der MARKTFHIGKEIT oder EIGNUNG FR EINEN BESTIMMTEN ZWECK.
    Siehe die GNU General Public License fr weitere Details.

    Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
    Programm erhalten haben. Wenn nicht, siehe <http://www.gnu.org/licenses/>.

*/


#include "stdafx.h"
#include "stdafx.h"
#include "Stepper.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Konstruktion/Destruktion
//////////////////////////////////////////////////////////////////////

CStepper::CStepper()
{
	state=0;
}

CStepper::~CStepper()
{

}

void CStepper::Up()
{
	if(state==3)
	{
		state=0;
	}
	else
	{
		state++;
	}
}

void CStepper::Down()
{
	if(state==0)
	{
		state=3;
	}
	else
	{
		state--;
	}
}

int CStepper::GetOutputs(unsigned char *out, unsigned char *enables)
{
	switch(state)
	{
	case 0:
		*out=0x1;
		*enables=0x1;
		break;
	case 1:
		*out=0x4;
		*enables=0x2;
		break;
	case 2:
		*out=0x2;
		*enables=0x1;
		break;
	case 3:
		*out=0x8;
		*enables=0x2;
		break;
	default:
		*out=0;
		*enables=0;
		return(0);
	}
		return(1);
}
