#! /bin/bash

##############################################################################
 # autoTunnel 0.2
##############################################################################

# /usr/local/bin/autoTunnel
# -     dz 2012
#
# Zweck:
# - Aenderungen der WAN- und LAN-IPv4-Adresse des lokalen Macs verfolgen
# und IPv6-Tunnel von Tunnelbroker aktualisieren
# - wird vom LaunchDaemon de.ct.dz.autoTunnel.plist zyklisch gestartet
#
# erzeugt auf:
#
# - Intel-Mac, Mac OS X 10.7.4
#
#
# Fortgang und Fehlermeldungen sind zu finden in
# /var/log/console.log und /var/log/autoTunnel.log
# 
# 

# Debugging einschalten
# set -x

VERSION="autoTunnel 0.2"
PATH=/bin:/usr/bin:/sbin:/usr/sbin

LOG="/var/log/autoTunnel.log"
CONFIGS="/etc/autoTunnel/"

#lokale Variablen
CACHEWAN=""
CACHELAN=""
#AKTUELLEWAN=`curl -s "http://v4.ipv6-test.com/api/myip.php"` # ohne UPnP, aber auf externen Dienst angewiesen
AKTUELLEWAN=`/opt/local/bin/upnpc -s | grep -i ExternalIP | awk '{ print $3}'` # ohne externen Dienst, aber eben auf UPnP im Router angewiesen

#einige weitere Abfragemoeglichkeiten...
#AKTUELLEWAN=`curl ifconfig.me`
#AKTUELLEWAN=$(/opt/local/bin/wget "http://freedns.afraid.org/dynamic/check.php" -o /dev/null -O /dev/stdout | grep Detected | cut -d : -f 2 | cut -d '<' -f 1 | tr -d " ")
#AKTUELLEWAN=`curl -s "http://www.networksecuritytoolkit.org/nst/cgi-bin/ip.cgi"`
#AKTUELLEWAN=`curl -s "http://checkip.dyndns.org"` #-qO - | cut -d : -f 2 | cut -d '<' -f 1
#AKTUELLEWAN=`curl -s "http://www.whatismyipaddress.com/" und so weiter...`

AKTUELLELAN=`/usr/bin/dscacheutil -q host -a name "$(hostname)" | awk '/^ip_address: / {print $2 ; exit }'`
#auch denkbar:
#AKTUELLELAN="dig +short $(hostname)" # das klappt aber nur, wenn der Router 
#dem Client einen Namen zugeteilt hat, deshalb besser nicht verwenden

WANIP="$CONFIGS/wanIP.cache"
LANIP="$CONFIGS/lanIP.cache"

#Tunnel-Variablen
TUSER="" # Name des Tunnel-Users
TPW="" # Passwort des Tunnel-Users
TUNNELID="" # die Tunnel-ID
TUNNELIPV4="" # IPv4-Adresse des Tunnels auf Anbieterseite
IPV6HIER="" # IPv6-Tunneladresse auf Teilnehmerseite
IPV6DORT="" # IPv6-Tunneladresse auf Tunnelbroker-Seite

# TunnelUpdate-Funktion
# siehe: http://ipv4.tunnelbroker.net/ipv4_end.php
# Usage: https://ipv4.tunnelbroker.net/ipv4_end.php?ip=IPV4ADDR&pass=MD5PASS&apikey=USERID&tid=TUNNELID
#  -or-: https://USERNAME:PASSWORD@ipv4.tunnelbroker.net/ipv4_end.php?tid=TUNNELID (auto-detect IP)
#        https://USERNAME:PASSWORD@ipv4.tunnelbroker.net/ipv4_end.php?tid=TUNNELID&ip=IPV4ADDR
# 
# IPV4ADDR: Your IPv4 endpoint. Set to AUTO to determine your IP based on
# the IP you requested this page from. Previously passed as ipv4b.
# MD5PASS : The MD5 hash of your password. You may be able to 'echo -n
# YOURPASSWORD | md5sum' to produce the MD5 hash of your password.
# USERID : The UserID shown on the main page of tunnelbroker.net when you
# log in. Previously referred to as user_id.
# TUNNELID: The ID of the tunnel you're updating the endpoint on. This can
# be found on the tunnel information page. Previously referred to as the
# Global Tunnel ID / tunnel_id.
# 
# The following parameters are only usable when accessing this script over https.
# USERNAME: Your tunnelbroker.net username.
# PASSWORD: Your tunnelbroker.net password.
# 
# The legacy parameter names will continue to work for the forseable
# future. Naming of them changed to be more in line with industry
# convention and their roles.

 TunnelUpdate ()
{   echo "aktualisiere Tunnelbroker IPv6-Tunnel"
    curl -k -s "https://"$TUSER":"$TPW"@ipv4.tunnelbroker.net/ipv4_end.php?tid="$TUNNELID""
    echo "" 
	}

# Tunnel-Setup-Funktion
  TunnelSetup ()
{
    # veraltete Tunnel-Konfiguration loeschen
    /sbin/route delete -inet6 default -interface gif0
    /sbin/ifconfig gif0 destroy
    # neue Tunnel-Konfiguration anlegen
    /sbin/ifconfig gif0 create
    echo "aktuelle LAN-IP-Adresse:" "$AKTUELLELAN"
    # Tunnel erzeugen
    /sbin/ifconfig gif0 tunnel "$AKTUELLELAN" "$TUNNELIPV4"
# mit Adressen belegen
    /sbin/ifconfig gif0 inet6 "$IPV6HIER" "$IPV6DORT" prefixlen 128
# Route setzen
    /sbin/route -n add -inet6 default -interface gif0
# falls der Mac im LAN routen soll, IPv6-Forwarding einschalten
    /usr/sbin/sysctl -w net.inet6.ip6.forwarding=1
	}     

########################Konfigurationsordner und Log-Datei anlegen
echo `date`, "$VERSION"

if ! [ -d "$CONFIGS" ];
    then
    echo "Ordner $CONFIGS fehlt, lege ihn an..."
    /bin/mkdir "$CONFIGS" 
fi

if ! [ -f "$LOG" ];
    then
    echo "$LOG fehlt, lege es an..."
    /usr/bin/touch "$LOG"
    /bin/chmod 644 "$LOG"
fi

#letzte WAN-IP einlesen
if test -f "$WANIP"
    then
    CACHEWAN=$(cat "$WANIP")
fi

#letzte LAN-IP einlesen
if test -f "$LANIP"
    then
    CACHELAN=$(cat "$LANIP")
fi

# fuer Debugging-Zwecke Kommentarzeichen entfernen:
#echo "Inhalt der Variablen CACHEWAN:" "$CACHEWAN"
#echo "Inhalt der Variablen AKTUELLEWAN:" "$AKTUELLEWAN"
#echo "Inhalt der Variablen CACHELAN:" "$CACHELAN"
#echo "Inhalt der Variablen AKTUELLELAN:" "$AKTUELLELAN"
 if [ "$AKTUELLEWAN" = "$CACHEWAN" ] && [ "$AKTUELLELAN" = "$CACHELAN" ]
 then
   echo "lokale IP-Adressen sind unveraendert, kein Update erforderlich..."
   echo ""
else
   echo "lokale Adressen sind geaendert, Aktualisierung erforderlich mit:" 
   echo "aktuelle WAN-IP: "$AKTUELLEWAN" und aktuelle LAN-IP: "$AKTUELLELAN""
   echo ""
    TunnelUpdate
    TunnelSetup
    echo ""
fi

echo "$AKTUELLEWAN" > "$WANIP"
echo "$AKTUELLELAN" > "$LANIP"
