Attribute VB_Name = "modLastDoc"
' Windows-API-Funktionen deklarieren
Declare Function GetCommandLine Lib "kernel32" Alias "GetCommandLineA" () As Long
Declare Function lstrcpyn_long_string Lib "kernel32" Alias "lstrcpynA" (ByVal DestString As String, ByVal SourcePointer As Long, ByVal MaxLen As Long) As Long
Declare Function lstrlen_long Lib "kernel32" Alias "lstrlenA" (ByVal SourcePointer As Long) As Long
      
Sub AutoExec()
    Dim WDStartedWithDoc As Boolean
    
    ' Fehlerverfolgung abschalten
    On Error Resume Next
       
    ' Wenn MRU-Liste mindestens einen Eintrag enthlt und kein Dokument
    ' geffnet ist, dann...
    If Application.RecentFiles.Count > 0 And Documents.Count = 0 Then
        ' ... Kommandozeile von Word prfen. Enthlt diese den N-Parameter zum ffnen
        ' eines per Doppelklick im Explorer gewhlten Dokuments?
        WDStartedWithDoc = InStr(GetComLine, "/n") > 0
    
        ' Nur wenn das NICHT der Fall ist, dann...
        If WDStartedWithDoc = False Then
            ' ... fragen, ob zuletzt geffnetes Dokument erneut geffnet werden soll. Falls ja, dann...
            If MsgBox(Application.RecentFiles(1).Name & " erneut ffnen?", _
                vbYesNoCancel + vbQuestion) = vbYes Then
                ' ... Dokument ffnen
                Application.RecentFiles(1).Open
            End If
        End If
    End If
End Sub

Public Function GetComLine() As String
    Dim Buffer As String
    Dim BufferLength As Long
    Dim ptrCommandLine As Long
    
    ' Kommandozeile mit API-Hilfe holen
    ptrCommandLine = GetCommandLine
    ' Wenn Ergebnis vorliegt, dann...
    If ptrCommandLine > 0 Then
        ' ... Lnge des Zeichenpuffers bestimmen
        BufferLength = lstrlen_long(ptrCommandLine)
      
        ' Wenn positive Lnge ermittelt, dann...
        If BufferLength > 0 Then
            ' ... Kommandozeile in Zeichenpuffer kopieren
            Buffer = Space(BufferLength + 1)
            ptrCommandLine = lstrcpyn_long_string(Buffer, ptrCommandLine, BufferLength + 1)
      
            ' Nullzeichen abtrennen
            If ptrCommandLine > 0 Then
                Dim PosZero As Long
                PosZero = InStr(Buffer, Chr$(0))
                If PosZero > 0 Then
                    Buffer = Left(Buffer, PosZero - 1)
                End If
            End If
        End If
    End If

    ' Kommandozeile als Zeichenkette zurckgeben
    GetComLine = Buffer
End Function


