/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.location.Location;
import android.location.LocationManager;
import org.apache.cordova.GPSListener;
import org.apache.cordova.NetworkListener;
import org.apache.cordova.api.Plugin;
import org.apache.cordova.api.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GeoBroker
extends Plugin {
    private GPSListener gpsListener;
    private NetworkListener networkListener;
    private LocationManager locationManager;

    public PluginResult execute(String action, JSONArray args, String callbackId) {
        if (this.locationManager == null) {
            this.locationManager = (LocationManager)this.cordova.getActivity().getSystemService("location");
            this.networkListener = new NetworkListener(this.locationManager, this);
            this.gpsListener = new GPSListener(this.locationManager, this);
        }
        PluginResult.Status status = PluginResult.Status.NO_RESULT;
        String message = "";
        PluginResult result = new PluginResult(status, message);
        result.setKeepCallback(true);
        try {
            if (action.equals("getLocation")) {
                boolean enableHighAccuracy = args.getBoolean(0);
                int maximumAge = args.getInt(1);
                Location last = this.locationManager.getLastKnownLocation(enableHighAccuracy ? "gps" : "network");
                if (System.currentTimeMillis() - last.getTime() <= (long)maximumAge) {
                    result = new PluginResult(PluginResult.Status.OK, this.returnLocationJSON(last));
                } else {
                    this.getCurrentLocation(callbackId, enableHighAccuracy);
                }
            } else if (action.equals("addWatch")) {
                String id = args.getString(0);
                boolean enableHighAccuracy = args.getBoolean(1);
                this.addWatch(id, callbackId, enableHighAccuracy);
            } else if (action.equals("clearWatch")) {
                String id = args.getString(0);
                this.clearWatch(id);
            }
        }
        catch (JSONException e) {
            result = new PluginResult(PluginResult.Status.JSON_EXCEPTION, e.getMessage());
        }
        return result;
    }

    private void clearWatch(String id) {
        this.gpsListener.clearWatch(id);
        this.networkListener.clearWatch(id);
    }

    private void getCurrentLocation(String callbackId, boolean enableHighAccuracy) {
        if (enableHighAccuracy) {
            this.gpsListener.addCallback(callbackId);
        } else {
            this.networkListener.addCallback(callbackId);
        }
    }

    private void addWatch(String timerId, String callbackId, boolean enableHighAccuracy) {
        if (enableHighAccuracy) {
            this.gpsListener.addWatch(timerId, callbackId);
        } else {
            this.networkListener.addWatch(timerId, callbackId);
        }
    }

    public boolean isSynch(String action) {
        return true;
    }

    public void onDestroy() {
        this.networkListener.destroy();
        this.gpsListener.destroy();
        this.networkListener = null;
        this.gpsListener = null;
    }

    public JSONObject returnLocationJSON(Location loc) {
        JSONObject o = new JSONObject();
        try {
            o.put("latitude", loc.getLatitude());
            o.put("longitude", loc.getLongitude());
            o.put("altitude", loc.hasAltitude() ? Double.valueOf(loc.getAltitude()) : null);
            o.put("accuracy", (double)loc.getAccuracy());
            o.put("heading", loc.hasBearing() ? (loc.hasSpeed() ? Float.valueOf(loc.getBearing()) : null) : null);
            o.put("speed", (double)loc.getSpeed());
            o.put("timestamp", loc.getTime());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return o;
    }

    public void win(Location loc, String callbackId) {
        PluginResult result = new PluginResult(PluginResult.Status.OK, this.returnLocationJSON(loc));
        this.success(result, callbackId);
    }

    public void fail(int code, String msg, String callbackId) {
        JSONObject obj = new JSONObject();
        String backup = null;
        try {
            obj.put("code", code);
            obj.put("message", (Object)msg);
        }
        catch (JSONException e) {
            obj = null;
            backup = "{'code':" + code + ",'message':'" + msg.replaceAll("'", "'") + "'}";
        }
        PluginResult result = obj != null ? new PluginResult(PluginResult.Status.ERROR, obj) : new PluginResult(PluginResult.Status.ERROR, backup);
        this.error(result, callbackId);
    }
}

