﻿using System;

namespace Gesundheitskarte
{
    class TLV
    {
        /// <summary>
        /// TLV-Struktur (Tag|Length|Value) wird nach dem Element mit dem Tag 'tag' durchsucht
        /// Wenn gefunden, wird der Inhalt des Elements (V) in element zurueckgegeben 
        /// </summary>
        /// <param name="bereich">Suchbereich</param>
        /// <param name="tag">Tag des gesuchten Elements</param>
        /// <param name="element">teilbereich des gesuchten Elements</param>
        /// <returns>bei Erfolg true, sonst false</returns>
        public bool sucheTag(byte[] bereich, byte tag, ref byte[] element)
        {
            int i = 0;

            // Tag suchen - bei Bereichsende abbrechen
            while ((bereich[i] != tag) && (i < bereich.Length))
            {
                i = i + 2 + bereich[i + 1]; // naechsten Tag adressieren
            }

            // Tag gefunden ?
            if (bereich[i] == tag)
            {
                int laenge = bereich[i + 1];    // Laengenangabe L steht im Byte nach dem Tag
                element = new byte[laenge];
                Array.Copy(bereich, i + 2, element, 0, laenge); // gefunden Teilbereich nach element[] kopieren
                return true;
            }
            else
                element = null;

            return false;
        }



        /// <summary>
        /// TLV-Struktur (Tag|Length|Value) wird nach dem Element mit dem Tag 'tag' durchsucht
        /// Wenn gefunden, wird der Inhalt des Elements (V) in element zurueckgegeben 
        /// Tag ist 16Bit breit
        /// </summary>
        /// <param name="bereich">Suchbereich</param>
        /// <param name="tagH">hoeherwertiger Teils des Tags des gesuchten Elements</param>
        /// <param name="tagL">niederwertiger Teils des Tags des gesuchten Elements</param>
        /// <param name="element">Teilbereich des gesuchten Elements</param>
        /// <returns>bei Erfolg true, sonst false</returns>
        public bool sucheTagCV(byte[] bereich, byte tagH, byte tagL, ref byte[] element)
        {
            int i = 0;

            // Tag suchen - bei Bereichsende abbrechen
            while ((bereich[i] != tagH) && (bereich[i + 1] != tagL) && (i < bereich.Length - 1))
            {
                i = i + 2 + 2 + bereich[i + 1]; // naechsten Tag adressieren
            }

            // Tag gefunden ?
            if ((bereich[i] == tagH) && (bereich[i + 1] == tagL))
            {
                // nach dem tag legt ein zusaetzlicher Bezeichner fest, 
                // ob eine zweistellige (0x82) oder einstellige (0x81) Laengenangabe folgt
                if (bereich[2] == 0x82) 
                {
                    int laenge = bereich[3] * 256 + bereich[4];    // Laengenangabe L steht in den zwei Bytes nach dem Tag + '0x82'
                    element = new byte[laenge];
                    Array.Copy(bereich, i + 5, element, 0, laenge);// gefundenen Teilbereich nach element[] kopieren
                }
                else
                {
                    int laenge = bereich[3];                        // Laengenangabe L steht im Byte nach dem Tag + '0x81'
                    element = new byte[laenge];
                    Array.Copy(bereich, i + 4, element, 0, laenge);// gefundenen Teilbereich nach element[] kopieren
                }

                return true;
            }
            else
                element = null;

            return false;
        }




    }
}
