void print_compilerinfo(void) {
#if defined __INTEL_COMPILER

printf ("compiled with Intel Compiler V%5.2f",(double)__INTEL_COMPILER/100);
 #if defined __INTEL_COMPILER_BUILD_DATE
    printf (", Build %d",__INTEL_COMPILER_BUILD_DATE);
 #endif 
 #if defined _MSC_VER 
	printf (", with MSVC %5.2f",(double)_MSC_VER/100);
 #endif 

#elif defined _MSC_VER 
	printf ("Microsoft Visual C V %5.2f, (%d)",(double)_MSC_VER/100,_MSC_FULL_VER);

#endif;

#if defined(__cplusplus)
	printf (", C++"); 
#else 
	printf(", C");
#endif;

#if defined _M_IX86_FP //only 32 Bit 
	switch (_M_IX86_FP) {
		case 0: printf (", /arch:IA32"); break; 
		case 1: printf (", /arch:SSE");  break;
		case 2: printf (", /arch:SSE2"); break;
		default: printf (", _M_IX86_FP= %d",_M_IX86_FP);break; 
	}
#endif;


printf ("\n"); 


#if defined WIN64 || defined _WIN64
	printf ("Windows 64"); 
#else 
 #if defined WIN32 
	printf ("Windows 32"); 
 #endif;
#endif;

#if defined linux 
    printf ("linux"); 
#endif 

#if defined unix 
    printf (", unix"); 
#endif 

#if defined __x86_64 || defined _M_IX64 || defined _AMD64_
	printf (", target: x86_64"); 
#endif; 

#if defined __ia64
	printf (", target: IA64"); 
#endif; 
    


#if defined __i386 || defined _M_IX86
	printf (", target: x86-32"); 
 #if defined _M_IX86 
	 printf (" for processor %d",_M_IX86);
 #endif; 
#endif;

#if defined _M_IX86_FP 
   printf (", _M_IX86_FP= %d", _M_IX86_FP);
#endif 


#if defined _DEBUG
	 printf (" debug, "); 
#else 
     printf (" Release, ");
#endif;

#if defined _DLL
	 printf ("RTL-DLL, ");
#else 
	 printf ("RTL embedded., ");
#endif;

#if defined _MT 
	 printf ("Multi Threaded, ");
#else 
	 printf ("Single Threaded, ");
#endif

#if defined _OPENMP
    printf ("openmp= %d",_OPENMP); 
#endif; 

#if defined _PGO_INSTRUMENT
   printf (", openmp= %d",_OPENMP); 
#endif; 



printf ("\n");
}