/**
 * The Computer Language Benchmarks Game
 * http://benchmarksgame.alioth.debian.org/
 * contributed by Klaus Friedel
 */

import java.util.concurrent.locks.LockSupport;

public class threadring 
{
	static final int THREAD_COUNT = 503;
	static boolean done;

	public static class MessageThread extends Thread 
	{
		MessageThread nextThread;
		volatile Integer message;

		public MessageThread( MessageThread nextThread, int name) 
		{
			super( "" + name);
			this.nextThread = nextThread;
		}

		public void run() 
		{
			done = false;

			while( true) 
			{
				nextThread.enqueue( dequeue());
      
				if ( done) break; 
			}	    
		}

		public void enqueue( Integer hopsRemaining) 
		{
			if ( hopsRemaining == 0)
			{
				// System.out.println(getName());

				done = true;
				// System.exit(0);
			}
			
			// as only one message populates the ring, it's impossible
			// that queue is not empty
			message = hopsRemaining - 1;
			LockSupport.unpark( this); // work waiting...
		}

		private Integer dequeue()
		{
			while ( message == null)
			{
				LockSupport.park();
			}
      
			Integer msg = message;
			message = null;
      
			return msg;
		}
	}

  public static void warmUp( String[] args) throws Exception
  { for ( int i = 0; i < 100; i++) benchmark( args);
  }

  public static void benchmark( String[] args) throws Exception 
  {
    int hopCount = Integer.parseInt( args[0]);

	MessageThread first = null;
    MessageThread last = null;
    
	for ( int i = THREAD_COUNT; i >= 1 ; i--) 
	{
		first = new MessageThread( first, i);
      
		if ( i == THREAD_COUNT) last = first;
    }
	
    // close the ring:
    last.nextThread = first;

    // start all Threads
    MessageThread t = first;
    
	do
	{
		t.start();
		t = t.nextThread;
    }
	while( t != first);
    
	// inject message
    first.enqueue( hopCount);
    first.join(); // wait for System.exit
  }  

  public static void main( String args[]) throws Exception
  {
    //for ( int mI = 0; mI < 5; mI++)
    //{   
      System.out.println( "Starte WarmUp ...");
      warmUp( args);
      System.out.println( "Beende WarmUp ...");

      long begin = System.currentTimeMillis();

      for ( int i = 0; i < 100; i++)
      {
		long beginTmp = System.currentTimeMillis();
        benchmark( args);
        
		long endTmp = System.currentTimeMillis();
        System.out.print( ( endTmp-beginTmp) + " ms, "); 
      }

      long end = System.currentTimeMillis();
      System.out.println( "Gesamtzeit: " + (end - begin) + " ms");
    //}

    System.exit( 0);
  }
}