#!/bin/bash

# Bitte an eigene Vorgaben anpassen !!!
REPEATER=repeater.example.com:5500

newpasswd()
{
	echo "Erzeuge neues Passwort ..."
	# PASSWD=$(makepasswd --string 0123456789 --maxchars 8)
	PASSWD=""
	MAXCOUNT=8
	count=1
	RANGE=9
	while [ "$count" -le $MAXCOUNT ]
	do
		number=$RANDOM
		let "number %= $RANGE"
		PASSWD=${PASSWD}${number}
		let "count += 1"
	done
}

newvncid()
{
	echo "Erzeuge neues Verbindungs-ID ..."
	VNCID=""
	MAXCOUNT=6
	count=1
	RANGE=9
	while [ "$count" -le $MAXCOUNT ]
	do
		number=$RANDOM
		let "number %= $RANGE"
		VNCID=${VNCID}${number}
		let "count += 1"
	done
}

show()
{
cat<<EOF
**********************************************
Verbindungsdaten:

Verbindungs-ID: ${VNCID} 
Passwort      : ${PASSWD}

Verbindungs-ID und Passwort bitte per Telefon
dem Helfer mitteilen.
**********************************************
Verbindung läuft über ${REPEATER}
**********************************************
EOF
}

##
# Zufällige Verbindungsdaten erstellen
newpasswd
newvncid
show

# run x11vnc, connect to repeater and wait
x11vnc -q -ssl -passwd ${PASSWD} -connect_or_exit repeater://${REPEATER}+ID:${VNCID} \
    -env X11VNC_DISABLE_SSL_CLIENT_MODE=1 -loop300,2 -sslonly -display :0




