#cs ----------------------------------------------------------------------------

 AutoIt Version: 3.3.8.1
 Author:         Reiko Kaps <rek@ct.de>

 Script Function:
	Generiert zufllige Repeater-ID und ein VNC-Passwort,
	startet damit den UltraVNC SC (Repeater-Modus), der 
	im selben Verzeichnis liegen muss
	
	Nutzt Verschlsselung via MSRC4Plugin.dsm (Option -plugin)
	und bentigt daher einen privaten Schlssel (*_ClientAuth.pubkey)

#ce ----------------------------------------------------------------------------

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Bitte an eigene Vorgaben anpassen !!!
global $repeater = "repeater.example.com:5500"
global $hinweis = "Bitte geben Sie die achtstellige ID" & @CRLF & "an den Helfer weiter!" & @CRLF & "Mit OK geht es los." & @CRLF

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Ab hier nichts ndern:
$version = 0.1
$appname = "c't-helferlein"
$vncprg = "\winvnc_SCII_100.exe"

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Erzeuge zufllige Repeater-Kennung
Func genID()
   Local $id
   for $i = 0 to 7
	  $id = $id & Round(Random(0,9))
   Next   
   Return $id
EndFunc      	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; starte winvnc.exe 
func startVNC($id)
   TrayTip("Verbinde zum Helfer",  "ID: " & $id, 15)
   sleep(2000)
   if FileExists(@ScriptDir & $vncprg) Then
	  ;;  -id 54321 -connect repeater.example.com:5500 -noregistry
	  ConsoleWrite("Running: " & @ScriptDir & $vncprg & " -plugin -id " & $id & " -connect " & $repeater & " -noregistry" & @CRLF)
	  $pid = Run(@ScriptDir & $vncprg & " -plugin -id " & $id & " -connect " & $repeater & " -noregistry")
   Else
	  MsgBox(18, $appname & " " & $version, "Kann den VNC-Server " & $vncprg & @CRLF & "unter " & @ScriptDir & @crlf & "nicht finden!")
	  Exit
   EndIf   
   return $pid
EndFunc

;; Passwort und Kennung erzeugen
;; $password = genPass()
$id = genID()

;; Anzeigen ....
$ret = MsgBox(49, $appname & " " & $version, $hinweis & @CRLF & "ID:             " & $id & @CRLF)

;; bei OK, VNC-Server starten
if $ret < 2 Then
   $vnc = startVNC($id)
   
   while ProcessExists($vnc)
	  ConsoleWrite("VNC-PID: " & $vnc & @CRLF)
	  $answer = MsgBox(1, $appname & " " & $version, "VNC-Sitzung luft!" & @CRLF & "ID: " & $id & @CRLF & "Sitzung beenden?")
	  if $answer == 1 Then
		 ConsoleWrite("Beende VNC-Server (" & $vnc & ")..." & @CRLF)
		 ProcessClose($vnc)
	  EndIf
   WEnd
   
endif
