﻿// chemistry.js: Definiert Klassen und Namespaces, um chemische Elemente zu verwalten;

(function () {
    "use strict";

    var Element = function (number, name, engName, symbol, row, column) {
        this.number = number;
        this.name = name;
        this.engName = engName;
        this.symbol = symbol;
        this.row = row;
        this.column = column;
    };

    var Elements = function () {
        this._theList = [];

        this.addElement = function (el) {
            this._theList.push(el);
        };

        this.getAt = function (idx) {
            return this._theList[idx];
        };

        this.forEach = function (fun) {
            for (var i = 0; i < this._theList.length; i++) {
                fun(this._theList[i], i);
            }
        };

        this.loadListAsync = function () {
            var that = this;
            var uri = new Windows.Foundation.Uri('ms-appx:///elements.txt');
            return Windows.Storage.StorageFile.getFileFromApplicationUriAsync(uri)
            .then(function (file) {
                return Windows.Storage.FileIO.readLinesAsync(file);
            })
            .then(function (lines) {
                var firstLine = true;
                lines.forEach(function (line) {
                    if (firstLine) {
                        firstLine = false;
                    }
                    else {
                        var cols = line.split('\t');
                        var elem = new Element(cols[0], cols[2], cols[1], cols[3], cols[7], cols[8]);
                        that.addElement(elem);
                    }
                });
            });
        };
    };

    WinJS.Namespace.define("Chemistry", {
        Element: Element,
        Elements: Elements
    });
})();
