﻿(function () {
    "use strict";

    WinJS.Binding.optimizeBindingReferences = true;
    var elements = new Chemistry.Elements();

    WinJS.UI.Pages.define("/pages/home/home.html", {
        // Diese Funktion wird immer aufgerufen, wenn ein Benutzer zu dieser Seite wechselt. Sie
        // füllt die Seitenelemente mit den Daten der App auf.
        ready: function (element, options) {
            // TODO: Die Seite hier initialisieren.
            this.loadElements();
        },

        loadElements: function () {
            var that = this;
            elements.loadListAsync()
            .then(function () {
                var grid = document.getElementById('elements');
                var template = document.getElementById('elementTemplate');
                var templateControl = template.winControl;
                elements.forEach(function (el) {
                    templateControl.render(WinJS.Binding.as(el))
                    .done(function (newDiv) {
                        var elemDiv = newDiv.getElementsByClassName('element')[0];
                        elemDiv.addEventListener('click', function () { that.elementClick(el); });
                        grid.appendChild(elemDiv);
                    });
                });
            });
        },

        elementClick: function (elem) {
            WinJS.Navigation.navigate('/pages/details/details.html', elem);
        }
    });
})();
