﻿using UnityEngine;
using System.Collections;

public class Clown : MonoBehaviour
{

  public float frictionCompensation = 1.1f;
  public float minVerticalVelocity = 3f;
  public float maxJumpVelocity = 14f;

  private bool isJumping = false;
  private bool crashed = false;
  private Animator animator;
  private float lastVelocityY = 0.1f;
  private Punkte scoreBoard;

  // Use this for initialization
  void Start()
  {
    animator = GetComponent<Animator>();
    scoreBoard = GameObject.Find("Punkte").GetComponent<Punkte>();
  }
  
  // Update is called once per frame
  void Update()
  {
    float velocityY = rigidbody2D.velocity.y;
    if(velocityY <= 0f && lastVelocityY > 0f) {
      // Wir haben gerade angefangen zu fallen
      animator.SetTrigger("Umkehr");
    }
    // Steig- / Fallgeschwindigkeit fürs nächste Mal merken
    lastVelocityY = velocityY;
  }

  void OnTriggerEnter2D(Collider2D coll)
  {
    if(coll.name == "Trampolin" && !isJumping && !crashed)
      StartCoroutine(Jump(coll.gameObject));
    else if(coll.tag == "Ballon") {
      Ballon balloon = coll.gameObject.GetComponent<Ballon>();
      int score = balloon.GetScore();
      scoreBoard.Score += score;
      balloon.Burst();
    }
  }

  IEnumerator Jump(GameObject trampoline)
  {
    isJumping = true;
    animator.SetTrigger("Springen");
    Vector2 velocityDown = rigidbody2D.velocity;
    // Erst mal weiter in X-Richtung, umkehren in Y-Richtung
    Vector2 velocityUp = new Vector2(velocityDown.x, -velocityDown.y) * frictionCompensation;
    // Je weiter aus der Mitte der Aufsprung, desto schräger ...
    float dx = trampoline.transform.position.x - this.transform.position.x;
    // ... und kürzer der Absprung
    float outsideFriction = 1f - Mathf.Abs(velocityUp.x + dx);
    velocityUp += new Vector2(dx, outsideFriction);
    // Bei zu flachem Absprung gibts noch ein bisschen Höhenbonus
    if(velocityUp.y < minVerticalVelocity)
      velocityUp.y = minVerticalVelocity;
    // Insgesamt aber nicht zu doll springen
    velocityUp = Vector2.ClampMagnitude(velocityUp, maxJumpVelocity);
    // Sprung über die nächsten paar Frames verteilen für natürliches Aussehen
    int frames = 8;
    for(int f = 1; f <= frames; f++) {
      rigidbody2D.velocity = Vector2.Lerp(velocityDown, velocityUp, (float)f / frames);
      yield return null;
    }
    isJumping = false;
  }
  
  void OnCollisionEnter2D(Collision2D coll)
  {
    if(coll.collider.name == "Boden" && !isJumping) {
      crashed = true;
      animator.SetTrigger("Daneben");
      // Bei Berührungen mit dem Trampolin nicht mehr springen
      GameObject trampo = GameObject.Find("Trampolin");
      foreach(var tc in trampo.GetComponents<Collider2D>())
        tc.isTrigger = true;
      // Noch 'ne Runde ...
      StartCoroutine(RestartGame());
    }
  }

  IEnumerator RestartGame()
  {      
    // Kurze Pause ...
    yield return new WaitForSeconds(5);
    // ... und dann das Level neu laden
    Application.LoadLevel(Application.loadedLevel);
  }

}
