!define VERSION "1.1"
!define NAME "Eventwatch"
!define UNINSTREG "Software\Microsoft\Windows\CurrentVersion\Uninstall\eventwatch"

; Dialoge
!include "MUI2.nsh"
!include "eventwatch_mail.nsdinc"
!include "eventwatch_config.nsdinc"

; fuer bequemes if&co.
!include "logiclib.nsh"
!include "WinVer.nsh"
!include "TextFunc.nsh"
!include "WordFunc.nsh"
!include "StrRep.nsh"
!include "ReplaceInFile.nsh"

; fuer Platzhalter in Edit-Controls
!ifndef EM_SETCUEBANNER
!define EM_SETCUEBANNER 0x1501 ; NT5 w/Themes & Vista+
!endif

; sonstige globale Angaben
Name "${NAME} ${VERSION}"
OutFile "eventwatch.exe"
InstallDir "$PROGRAMFILES\eventwatch"
InstallDirRegKey HKLM "Software\eventwatch" "Install_Dir"
RequestExecutionLevel admin
!define MUI_ABORTWARNING
!define MUI_ICON "eventwatch.ico"

; Variablen fuer Dialogdaten
Var my_receiver
Var my_sender
Var my_smtppassword
Var my_smtpserver
Var my_smtpuser
Var my_smtpport
Var my_blacklisturl

; Anzuzeigende Dialog-Seiten
  !insertmacro MUI_PAGE_DIRECTORY
  Page custom MailConfig
  Page custom GeneralConfig
  !insertmacro MUI_PAGE_INSTFILES
  !insertmacro MUI_PAGE_FINISH
  !insertmacro MUI_UNPAGE_CONFIRM
  !insertmacro MUI_UNPAGE_INSTFILES
  
; Sprache (darf erst hier stehen)
!insertmacro MUI_LANGUAGE "German"

; wird beim Start aufgerufen
Function .onInit
	${IfNot} ${AtLeastWin7}
		MessageBox MB_OK "Mindestens Windows 7 ist Voraussetzung."
		Quit
	${EndIf}
	nsExec::ExecToStack 'PowerShell -Command $PSVersionTable.PSVersion.Major'
	pop $0
	pop $1
	${If} $1 < 4
		MessageBox MB_OK "Mindestens Powershell 4 ist Voraussetzung."
		Quit
	${EndIf}
    InitPluginsDir
		file /oname=$PLUGINSDIR\EventWatch_vars.ps1.example "EventWatch_vars.ps1.example"
		file /oname=$PLUGINSDIR\EventWatch.ps1 "EventWatch.ps1"
	; bei erneutem Aufruf Konfigurationsdaten einlesen
	ClearErrors
	push $INSTDIR
	ReadRegStr $0 HKLM SOFTWARE\eventwatch "Install_Dir"
	StrCpy $my_smtpport "25"
	${IfNot} ${Errors}
		push $0
		pop $INSTDIR
		Call ReadConfigFile
	${EndIf}
FunctionEnd

; Mailkonfiguration abfragen
Function MailConfig
	Call fnc_eventwatch_mail_Create
	${NSD_SetText} $hCtl_eventwatch_mail_receiver $my_receiver
	${NSD_SetText} $hCtl_eventwatch_mail_sender $my_sender
	${If} $my_smtpport == "25"
		${NSD_SetText} $hCtl_eventwatch_mail_smtpserver $my_smtpserver
	${Else}
		${NSD_SetText} $hCtl_eventwatch_mail_smtpserver "$my_smtpserver:$my_smtpport"
	${EndIf}
	${NSD_SetText} $hCtl_eventwatch_mail_smtpuser $my_smtpuser
	${NSD_SetText} $hCtl_eventwatch_mail_smtppassword $my_smtppassword
	System::Call 'USER32::SendMessage(i$hCtl_eventwatch_mail_receiver,i${EM_SETCUEBANNER},i0,w"Jens Mander <jens@example.com>")'
	System::Call 'USER32::SendMessage(i$hCtl_eventwatch_mail_sender,i${EM_SETCUEBANNER},i0,w"Eventwatch <jens@example.com>")'
	System::Call 'USER32::SendMessage(i$hCtl_eventwatch_mail_smtpserver,i${EM_SETCUEBANNER},i0,w"smtp.example.com")'
	System::Call 'USER32::SendMessage(i$hCtl_eventwatch_mail_smtpuser,i${EM_SETCUEBANNER},i0,w"<Konto> (optional)")'
	System::Call 'USER32::SendMessage(i$hCtl_eventwatch_mail_smtppassword,i${EM_SETCUEBANNER},i0,w"<Passwort> (optional)")'
    nsDialogs::Show $hCtl_eventwatch_mail	
FunctionEnd

; Sonstige Konfigurationsdaten abfragen
Function GeneralConfig
	Call fnc_eventwatch_config_Create
	${NSD_SetText} $hCtl_eventwatch_config_blacklisturl $my_blacklisturl
	System::Call 'USER32::SendMessage(i$hCtl_eventwatch_config_blacklisturl,i${EM_SETCUEBANNER},i0,w"http://example.com/blacklist.xml (optional)")'
	nsDialogs::Show $hCtl_eventwatch_config
FunctionEnd	

; Die Auftraege (Sections)
Section "Eventwatch" Eventwatch
	; Daten verteilen
    SetOutPath "$INSTDIR"
    File EventWatch.ps1
    File blacklist.xml
    File EventWatch_vars.ps1.example
    File EventWatch.xml
	File eventwatch.ico
	Call WriteConfigFile
	Delete $INSTDIR\EventWatch_vars.ps1
	Rename $PLUGINSDIR\Eventwatch_vars.ps1 EventWatch_vars.ps1
  
    ; Installationspfad in die Registry
    WriteRegStr HKLM SOFTWARE\eventwatch "Install_Dir" "$INSTDIR"
  
    ; Damit die Deinstallation in der Systemsteuerung auftaucht
    WriteRegStr HKLM "${UNINSTREG}" "DisplayName" "${NAME}"
	WriteRegStr HKLM "${UNINSTREG}" "DisplayVersion" "${VERSION}"
    WriteRegStr HKLM "${UNINSTREG}" "Publisher" "c't-Redaktion"
    WriteRegStr HKLM "${UNINSTREG}" "URLInfoAbout" "http://www.ct.de/-2198747"
    WriteRegStr HKLM "${UNINSTREG}" "DisplayIcon" '"$INSTDIR\eventwatch.ico"'
    WriteRegStr HKLM "${UNINSTREG}" "UninstallString" '"$INSTDIR\uninstall.exe"'
    WriteRegDWORD HKLM "${UNINSTREG}" "NoModify" 1
    WriteRegDWORD HKLM "${UNINSTREG}" "NoRepair" 1
    WriteUninstaller "uninstall.exe"
SectionEnd

; Einrichten der geplaten Aufgabe
Section "Install & register task"
    DetailPrint "Installing, registering and starting the scheduled task ..."
	!insertmacro _ReplaceInFile "$INSTDIR\eventwatch.xml" "REALPATHANDNAME" "$INSTDIR"
	Delete "$INSTDIR\eventwatch.xml.old"
    nsExec::Exec 'schtasks /create /xml "$INSTDIR\eventwatch.xml" /tn eventwatch'
SectionEnd

; Alles wegwerfen
Section "Uninstall"
    ; Geplante Aufgabe abraeumen
    DetailPrint "Removing scripts..."
    nsExec::Exec 'schtasks /delete /tn eventwatch /f'
	
	; Installationsverzeichnis aus der Registry holen
	ReadRegStr $INSTDIR HKLM SOFTWARE\eventwatch "Install_Dir"
  
    ; Registry putzen
    DeleteRegKey HKLM "${UNINSTREG}"
    DeleteRegKey HKLM SOFTWARE\eventwatch
  
    ; Dateien weg
    Delete "$INSTDIR\EventWatch.ps1"
    Delete "$INSTDIR\blacklist.xml"
    Delete "$INSTDIR\EventWatch_vars.ps1"
    Delete "$INSTDIR\EventWatch_vars.ps1.example"
    Delete "$INSTDIR\EventWatch.xml"
    Delete "$INSTDIR\uninstall.exe"
	Delete "$INSTDIR\eventwatch.ico"
  
    ; Jetzt das Verzeichnis (wenn denn leer)
    RMDir "$INSTDIR"
SectionEnd

; Daten in Konfigurationsdatei schreiben
Function WriteConfigFile
    FileOpen $0 $PLUGINSDIR\EventWatch_vars.ps1 w
	FileWrite $0 "$$smtpserver=$\"$my_smtpserver$\"$\r$\n"
	FileWrite $0 "$$smtpuser=$\"$my_smtpuser$\"$\r$\n"
	FileWrite $0 "$$smtppass=$\"$my_smtppassword$\"$\r$\n"
	FileWrite $0 "$$to=$\"$my_receiver$\"$\r$\n"
	FileWrite $0 "$$from=$\"$my_sender$\"$\r$\n"
	FileWrite $0 "$$smtpport=$\"$my_smtpport$\"$\r$\n"
	FileWrite $0 "$$blacklisturl=$\"$my_blacklisturl$\"$\r$\n"
	FileClose $0
FunctionEnd

; Daten aus Konfigurationsdatei lesen
Function ReadConfigFile
	${ConfigRead} "$INSTDIR\EventWatch_vars.ps1" "$$smtpserver=" $0
	StrCpy $my_smtpserver $0 -1 1 
	${ConfigRead} "$INSTDIR\EventWatch_vars.ps1" "$$smtpuser=" $0
	StrCpy $my_smtpuser $0 -1 1
	${ConfigRead} "$INSTDIR\EventWatch_vars.ps1" "$$smtppass=" $0
	StrCpy $my_smtppassword $0 -1 1
	${ConfigRead} "$INSTDIR\EventWatch_vars.ps1" "$$to=" $0
	StrCpy $my_receiver $0 -1 1
	${ConfigRead} "$INSTDIR\EventWatch_vars.ps1" "$$from=" $0
	StrCpy $my_sender $0 -1 1
	${ConfigRead} "$INSTDIR\EventWatch_vars.ps1" "$$smtpport=" $0
	StrCpy $my_smtpport $0 -1 1
	${ConfigRead} "$INSTDIR\EventWatch_vars.ps1" "$$blacklisturl=" $0
	StrCpy $my_blacklisturl $0 -1 1
	${ConfigRead} "$INSTDIR\EventWatch_vars.ps1" "$$to=" $0
	StrCpy $my_receiver $0 -1 1
FunctionEnd

; Callback-Funktionen fuer Datenuebergabe
Function oc_receiver
	pop $0
	${NSD_GetText} $hCtl_eventwatch_mail_receiver $my_receiver
FunctionEnd

Function oc_sender
	pop $0
	${NSD_GetText} $hCtl_eventwatch_mail_sender $my_sender
FunctionEnd

Function oc_smtpserver
	pop $0
	${NSD_GetText} $hCtl_eventwatch_mail_smtpserver $0
	${WordFind} "$0" ":" "+1" $my_smtpserver
	${WordFind} "$0" ":" "-1" $my_smtpport
	${If} $my_smtpserver == $my_smtpport
		StrCpy $my_smtpport "25"
	${EndIf}
FunctionEnd

Function oc_smtpuser
	pop $0
	${NSD_GetText} $hCtl_eventwatch_mail_smtpuser $my_smtpuser
FunctionEnd

Function oc_smtppassword
	pop $0
	${NSD_GetText} $hCtl_eventwatch_mail_smtppassword $my_smtppassword
FunctionEnd
	
Function oc_blacklisturl
	pop $0
	${NSD_GetText} $hCtl_eventwatch_config_blacklisturl $my_blacklisturl
FunctionEnd

; Test-Mail verschicken, Ergebnis anzeigen
Function TestMailSend
	Call WriteConfigFile
	nsExec::ExecToStack 'powershell -ExecutionPolicy remotesigned -noninteractive -command $PLUGINSDIR\EventWatch.ps1 -mailcheck'
	pop $0
	pop $1
	${If} $0 = 0
		MessageBox MB_OK "Mail erfolgreich verschickt."
	${Else}
		MessageBox MB_ICONEXCLAMATION "Fehler beim Verschicken der Test-Mail:$\r$\n$1"
	${EndIf}
FunctionEnd