﻿$oldIP = '0.0.0.0';
$firstSeen = Get-Date;
$lastSeen = Get-Date;
$reset = $false;
$history = @();
$log = Get-EventLog -LogName PowerShell-Skripte -Source IP-Wächter;
foreach($entry in $log) { # Umgekehrt chronologisch; neuester Eintrag zuerst
    if($entry.InstanceId -eq 1) {
        if(-not ($entry.Message -match '\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}')) {
            continue;
        }
        $ip = $Matches[0];
        if($ip -ne $oldIP) {
            if($oldIP -ne '0.0.0.0') {
                $historyEntry = New-Object System.Object;
                $historyEntry | Add-Member -type NoteProperty -name IP -value $oldIP;
                $historyEntry | Add-Member -type NoteProperty -name FirstSeen -value $firstSeen;
                $historyEntry | Add-Member -type NoteProperty -name LastSeen -value $lastSeen;
                $historyEntry | Add-Member -type NoteProperty -name ManualRelease -value $reset;
                $history += $historyEntry;
                $lastSeen = $entry.TimeWritten;
            }
            $oldIP = $ip;
            $reset = $false;
        }
        $firstSeen = $entry.TimeWritten;
    }
    elseif($entry.InstanceId -eq 2) {
        if(-not ($entry.Message -match '(\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}) -> (\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})')) {
            continue;
        }
        $ip1 = $Matches[1];
        $ip2 = $Matches[2];
        if($ip2 -ne $oldIP) {
            if($oldIP -ne '0.0.0.0') {
                $historyEntry = New-Object System.Object;
                $historyEntry | Add-Member -type NoteProperty -name IP -value $oldIP;
                $historyEntry | Add-Member -type NoteProperty -name FirstSeen -value $firstSeen;
                $historyEntry | Add-Member -type NoteProperty -name LastSeen -value $lastSeen;
                $historyEntry | Add-Member -type NoteProperty -name ManualRelease -value $reset;
                $history += $historyEntry;
                $lastSeen = $entry.TimeWritten;
            }
            $oldIP = $ip2;
            $reset = $false;
        }
        $historyEntry = New-Object System.Object;
        $historyEntry | Add-Member -type NoteProperty -name IP -value $oldIP;
        $historyEntry | Add-Member -type NoteProperty -name FirstSeen -value $entry.TimeWritten;
        $historyEntry | Add-Member -type NoteProperty -name LastSeen -value $lastSeen;
        $historyEntry | Add-Member -type NoteProperty -name ManualRelease -value $reset;
        $history += $historyEntry;
        $lastSeen = $entry.TimeWritten;
        $firstSeen = $entry.TimeWritten;
        $oldIP = $ip1;
        $reset = $true;
    }
}
$historyEntry = New-Object System.Object;
$historyEntry | Add-Member -type NoteProperty -name IP -value $oldIP;
$historyEntry | Add-Member -type NoteProperty -name FirstSeen -value $firstSeen;
$historyEntry | Add-Member -type NoteProperty -name LastSeen -value $lastSeen;
$historyEntry | Add-Member -type NoteProperty -name ManualRelease -value $reset;
$history += $historyEntry;

$format = @();
$format += 'IP';
$format += @{Label='Von'; Expression={$_.FirstSeen.ToString('ddd. dd.MM.yy HH:mm')}};
$format += @{Label='Bis'; Expression={$_.LastSeen.ToString('ddd. dd.MM.yy HH:mm')}};
$format += @{Label='Dauer'; Expression={($_.LastSeen - $_.FirstSeen).ToString("d' Tage, 'hh\:mm' Std'")}};
$format += @{Label='Manuell zurückgesetzt'; Expression={@{$true='Ja'; $false='Nein'}[$_.ManualRelease]}};
$history | Format-Table -Property $format;
